/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.tileentity.table.crafting;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import slimeknights.mantle.recipe.inventory.ISingleItemInventory;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationInventory;
import slimeknights.tconstruct.tables.tileentity.table.TinkerStationTileEntity;

public class TinkerStationInventoryWrapper
implements IMutableTinkerStationInventory {
    private final TinkerStationTileEntity station;
    private MaterialRecipe[] materials;
    private boolean[] searchedMaterial;
    private MaterialRecipe lastMaterialRecipe;
    @Nullable
    private PlayerEntity player;

    public TinkerStationInventoryWrapper(TinkerStationTileEntity station) {
        this.station = station;
        int count = station.getInputCount();
        this.materials = new MaterialRecipe[count];
        this.searchedMaterial = new boolean[count];
    }

    @Nullable
    private MaterialRecipe findMaterialRecipe(ItemStack stack) {
        World world = this.station.func_145831_w();
        if (world == null) {
            return null;
        }
        ISingleItemInventory inv = () -> stack;
        if (this.lastMaterialRecipe != null && this.lastMaterialRecipe.matches(inv, world)) {
            return this.lastMaterialRecipe;
        }
        Optional newRecipe = world.func_199532_z().func_215371_a(RecipeTypes.MATERIAL, (IInventory)inv, world);
        if (newRecipe.isPresent()) {
            this.lastMaterialRecipe = (MaterialRecipe)newRecipe.get();
            return this.lastMaterialRecipe;
        }
        return null;
    }

    public void refreshInput(int slot) {
        if (slot >= 1 && slot < this.station.getInputCount() + 1) {
            this.materials[slot - 1] = null;
            this.searchedMaterial[slot - 1] = false;
        }
    }

    public void resize() {
        int count = this.station.getInputCount();
        this.materials = new MaterialRecipe[count];
        this.searchedMaterial = new boolean[count];
    }

    @Override
    public ItemStack getTinkerableStack() {
        return this.station.func_70301_a(0);
    }

    @Override
    public ItemStack getInput(int index) {
        if (index < 0 || index >= this.station.getInputCount()) {
            return ItemStack.field_190927_a;
        }
        return this.station.func_70301_a(index + 1);
    }

    @Override
    public int getInputCount() {
        return this.station.getInputCount();
    }

    @Override
    @Nullable
    public MaterialRecipe getInputMaterial(int index) {
        if (index < 0 || index >= this.station.getInputCount()) {
            return null;
        }
        if (!this.searchedMaterial[index]) {
            this.materials[index] = this.findMaterialRecipe(this.getInput(index));
            this.searchedMaterial[index] = true;
        }
        return this.materials[index];
    }

    @Override
    public void setInput(int index, ItemStack stack) {
        if (index >= 0 && index < this.station.getInputCount()) {
            this.station.func_70299_a(index + 1, stack);
        }
    }

    @Override
    public void giveItem(ItemStack stack) {
        if (this.player != null) {
            this.player.field_71071_by.func_191975_a(this.player.func_130014_f_(), stack);
        }
    }

    public void setPlayer(@Nullable PlayerEntity player) {
        this.player = player;
    }
}

