/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.armor;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorInteractModifier;
import slimeknights.tconstruct.library.modifiers.impl.InventoryModifier;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ShieldStrapModifier
extends InventoryModifier
implements IArmorInteractModifier {
    private static final ResourceLocation KEY = TConstruct.getResource("shield_strap");
    private static final Pattern PATTERN = new Pattern("tconstruct", "shield_plus");

    public ShieldStrapModifier() {
        super(117709, KEY, 1);
    }

    @Override
    public int getPriority() {
        return 75;
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        super.addVolatileData(context, level, volatileData);
        volatileData.putBoolean(ToolInventoryCapability.INCLUDE_OFFHAND, true);
    }

    @Override
    public int getSlots(IToolContext tool, int level) {
        return level + tool.getModifierLevel((Modifier)TinkerModifiers.pocketChain.get());
    }

    @Override
    public boolean startArmorInteract(IModifierToolStack tool, int level, PlayerEntity player, EquipmentSlotType equipmentSlot) {
        if (!player.func_225608_bj_()) {
            if (player.field_70170_p.field_72995_K) {
                return false;
            }
            ItemStack offhand = player.func_184592_cb();
            int slots = this.getSlots(tool, level);
            if (offhand.func_190926_b() || !ToolInventoryCapability.isBlacklisted(offhand)) {
                ItemStack newOffhand = ItemStack.field_190927_a;
                ModDataNBT persistentData = tool.getPersistentData();
                ListNBT list = new ListNBT();
                if (persistentData.contains(KEY, 9)) {
                    ListNBT original = (ListNBT)persistentData.get(KEY, GET_COMPOUND_LIST);
                    for (int i = 0; i < original.size(); ++i) {
                        CompoundNBT compoundNBT = original.func_150305_b(i);
                        int slot = compoundNBT.func_74762_e("Slot");
                        if (slot == 0) {
                            newOffhand = ItemStack.func_199557_a((CompoundNBT)compoundNBT);
                            continue;
                        }
                        if (slot >= slots) continue;
                        CompoundNBT copy = compoundNBT.func_74737_b();
                        copy.func_74768_a("Slot", slot - 1);
                        list.add((Object)copy);
                    }
                }
                if (!offhand.func_190926_b()) {
                    list.add((Object)ShieldStrapModifier.write(offhand, slots - 1));
                }
                persistentData.put(KEY, (INBT)list);
                player.func_184611_a(Hand.OFF_HAND, newOffhand);
                if (!newOffhand.func_190926_b() || !list.isEmpty()) {
                    player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187719_p, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
        return false;
    }

    @Override
    @Nullable
    public Pattern getPattern(IModifierToolStack tool, int level, int slot, boolean hasStack) {
        return hasStack ? null : PATTERN;
    }

    @Override
    @Nullable
    public <T> T getModule(Class<T> type) {
        if (type == IArmorInteractModifier.class) {
            return (T)this;
        }
        return super.getModule(type);
    }
}

