/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.armor;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.TankModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorInteractModifier;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.SpillingRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.SpillingRecipeLookup;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.particle.FluidParticleData;

public class SlurpingModifier
extends TankModifier
implements IArmorInteractModifier {
    private static final float DEGREE_TO_RADIANS = (float)Math.PI / 180;
    private static final TinkerDataCapability.TinkerDataKey<SlurpingInfo> SLURP_FINISH_TIME = TConstruct.createKey("slurping_finish");

    public SlurpingModifier() {
        super(16352840, 1000);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, TickEvent.PlayerTickEvent.class, this::playerTick);
    }

    @Override
    public boolean startArmorInteract(IModifierToolStack tool, int level, PlayerEntity player, EquipmentSlotType slot) {
        SpillingRecipe recipe;
        FluidStack fluid;
        if (!player.func_225608_bj_() && !(fluid = this.getFluid(tool)).isEmpty() && (recipe = SpillingRecipeLookup.findRecipe(player.func_130014_f_().func_199532_z(), fluid.getFluid())) != null) {
            player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.put(SLURP_FINISH_TIME, new SlurpingInfo(fluid, player.field_70173_aa + 20)));
            return true;
        }
        return false;
    }

    private static void addFluidParticles(PlayerEntity player, FluidStack fluid, int count) {
        for (int i = 0; i < count; ++i) {
            Vector3d motion = new Vector3d(((double)RANDOM.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            motion = motion.func_178789_a(-player.field_70125_A * ((float)Math.PI / 180));
            motion = motion.func_178785_b(-player.field_70177_z * ((float)Math.PI / 180));
            Vector3d position = new Vector3d(((double)RANDOM.nextFloat() - 0.5) * 0.3, (double)(-RANDOM.nextFloat()) * 0.6 - 0.3, 0.6);
            position = position.func_178789_a(-player.field_70125_A * ((float)Math.PI / 180));
            position = position.func_178785_b(-player.field_70177_z * ((float)Math.PI / 180));
            position = position.func_72441_c(player.func_226277_ct_(), player.func_226280_cw_(), player.func_226281_cx_());
            FluidParticleData data = new FluidParticleData((ParticleType<FluidParticleData>)((ParticleType)TinkerCommons.fluidParticle.get()), fluid);
            if (player.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)player.field_70170_p).func_195598_a((IParticleData)data, position.field_72450_a, position.field_72448_b, position.field_72449_c, 1, motion.field_72450_a, motion.field_72448_b + 0.05, motion.field_72449_c, 0.0);
                continue;
            }
            player.field_70170_p.func_195594_a((IParticleData)data, position.field_72450_a, position.field_72448_b, position.field_72449_c, motion.field_72450_a, motion.field_72448_b + 0.05, motion.field_72449_c);
        }
    }

    private void playerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (player.func_175149_v()) {
            return;
        }
        player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
            SlurpingInfo info = data.get(SLURP_FINISH_TIME);
            if (info != null) {
                int timeLeft = info.finishTime - player.field_70173_aa;
                if (timeLeft < 0) {
                    SpillingRecipe recipe;
                    ToolStack tool;
                    FluidStack fluid;
                    player.func_184185_a(SoundEvents.field_187664_bz, 0.5f, RANDOM.nextFloat() * 0.1f + 0.9f);
                    SlurpingModifier.addFluidParticles(player, info.fluid, 16);
                    if (!player.func_130014_f_().field_72995_K && !(fluid = this.getFluid(tool = ToolStack.from(player.func_184582_a(EquipmentSlotType.HEAD)))).isEmpty() && (recipe = SpillingRecipeLookup.findRecipe(player.func_130014_f_().func_199532_z(), fluid.getFluid())) != null) {
                        ToolAttackContext context = new ToolAttackContext((LivingEntity)player, player, Hand.MAIN_HAND, (Entity)player, (LivingEntity)player, false, 1.0f, false);
                        FluidStack remaining = recipe.applyEffects(fluid, tool.getModifierLevel(this), context);
                        if (!player.func_184812_l_()) {
                            this.setFluid(tool, remaining);
                        }
                    }
                    data.remove(SLURP_FINISH_TIME);
                } else if (timeLeft % 4 == 0) {
                    player.func_184185_a(SoundEvents.field_187664_bz, 0.5f, RANDOM.nextFloat() * 0.1f + 0.9f);
                    SlurpingModifier.addFluidParticles(player, info.fluid, 5);
                }
            }
        });
    }

    @Override
    public void stopArmorInteract(IModifierToolStack tool, int level, PlayerEntity player, EquipmentSlotType slot) {
        player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.remove(SLURP_FINISH_TIME));
    }

    @Override
    @Nullable
    public <T> T getModule(Class<T> type) {
        if (type == IArmorInteractModifier.class) {
            return (T)this;
        }
        return super.getModule(type);
    }

    private static class SlurpingInfo {
        private final FluidStack fluid;
        private final int finishTime;

        public SlurpingInfo(FluidStack fluid, int finishTime) {
            this.fluid = fluid;
            this.finishTime = finishTime;
        }

        public FluidStack getFluid() {
            return this.fluid;
        }

        public int getFinishTime() {
            return this.finishTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SlurpingInfo)) {
                return false;
            }
            SlurpingInfo other = (SlurpingInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FluidStack this$fluid = this.getFluid();
            FluidStack other$fluid = other.getFluid();
            if (this$fluid == null ? other$fluid != null : !this$fluid.equals(other$fluid)) {
                return false;
            }
            return this.getFinishTime() == other.getFinishTime();
        }

        protected boolean canEqual(Object other) {
            return other instanceof SlurpingInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FluidStack $fluid = this.getFluid();
            result = result * 59 + ($fluid == null ? 43 : $fluid.hashCode());
            result = result * 59 + this.getFinishTime();
            return result;
        }

        public String toString() {
            return "SlurpingModifier.SlurpingInfo(fluid=" + this.getFluid() + ", finishTime=" + this.getFinishTime() + ")";
        }
    }
}

