/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.tool;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.modifiers.TankModifier;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.SpillingRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.SpillingRecipeLookup;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.particle.FluidParticleData;

public class SpillingModifier
extends TankModifier {
    public SpillingModifier() {
        super(16352840, 1000);
    }

    private static void spawnParticles(Entity target, FluidStack fluid) {
        if (target.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)target.field_70170_p).func_195598_a((IParticleData)new FluidParticleData((ParticleType<FluidParticleData>)((ParticleType)TinkerCommons.fluidParticle.get()), fluid), target.func_226277_ct_(), target.func_226283_e_(0.5), target.func_226281_cx_(), 10, 0.1, 0.2, 0.1, 0.2);
        }
    }

    @Override
    public void onAttacked(IModifierToolStack tool, int level, EquipmentContext context, EquipmentSlotType slotType, DamageSource source, float amount, boolean isDirectDamage) {
        FluidStack fluid;
        Entity attacker = source.func_76346_g();
        if (isDirectDamage && attacker != null && RANDOM.nextInt(4) < level && !(fluid = this.getFluid(tool)).isEmpty()) {
            LivingEntity self = context.getEntity();
            PlayerEntity player = self instanceof PlayerEntity ? (PlayerEntity)self : null;
            SpillingRecipe recipe = SpillingRecipeLookup.findRecipe(self.func_130014_f_().func_199532_z(), fluid.getFluid());
            if (recipe != null) {
                ToolAttackContext attackContext = new ToolAttackContext(self, player, Hand.MAIN_HAND, attacker, attacker instanceof LivingEntity ? (LivingEntity)attacker : null, false, 1.0f, false);
                FluidStack remaining = recipe.applyEffects(fluid, level, attackContext);
                SpillingModifier.spawnParticles(attacker, fluid);
                if (player == null || !player.func_184812_l_()) {
                    this.setFluid(tool, remaining);
                }
            }
        }
    }

    @Override
    public int afterEntityHit(IModifierToolStack tool, int level, ToolAttackContext context, float damageDealt) {
        SpillingRecipe recipe;
        FluidStack fluid;
        if (damageDealt > 0.0f && context.isFullyCharged() && !(fluid = this.getFluid(tool)).isEmpty() && (recipe = SpillingRecipeLookup.findRecipe(context.getAttacker().func_130014_f_().func_199532_z(), fluid.getFluid())) != null) {
            FluidStack remaining = recipe.applyEffects(fluid, level, context);
            SpillingModifier.spawnParticles(context.getTarget(), fluid);
            PlayerEntity player = context.getPlayerAttacker();
            if (player == null || !player.func_184812_l_()) {
                this.setFluid(tool, remaining);
            }
        }
        return 0;
    }
}

