/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.internal;

import net.minecraft.block.BlockState;
import net.minecraft.block.TripWireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.eventbus.api.Event;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.base.InteractionModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IShearModifier;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ShearsAbilityModifier
extends InteractionModifier.SingleUse {
    private final int range;
    private final int priority;

    public ShearsAbilityModifier(int color, int range, int priority) {
        super(color);
        this.range = range;
        this.priority = priority;
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return this.priority > Short.MIN_VALUE;
    }

    protected void swingTool(PlayerEntity player, Hand hand) {
        player.func_184609_a(hand);
        player.func_184810_cG();
    }

    protected boolean isShears(IModifierToolStack tool) {
        return true;
    }

    @Override
    public ActionResultType beforeEntityUse(IModifierToolStack tool, int level, PlayerEntity player, Entity target, Hand hand, EquipmentSlotType slotType) {
        if (tool.isBroken()) {
            return ActionResultType.PASS;
        }
        ItemStack stack = player.func_184582_a(slotType);
        int looting = ModifierUtil.getLootingLevel(tool, (LivingEntity)player, target, null);
        looting = ModifierUtil.getLeggingsLootingLevel((LivingEntity)player, target, null, looting);
        World world = player.func_130014_f_();
        if (this.isShears(tool) && ShearsAbilityModifier.shearEntity(stack, tool, world, player, target, looting)) {
            int expanded;
            boolean broken = ToolDamageUtil.damageAnimated(tool, 1, (LivingEntity)player, slotType);
            this.swingTool(player, hand);
            ShearsAbilityModifier.runShearHook(tool, player, target, true);
            if (!broken && (expanded = this.range + tool.getModifierLevel((Modifier)TinkerModifiers.expanded.get())) > 0) {
                for (LivingEntity aoeTarget : player.func_130014_f_().func_217357_a(LivingEntity.class, target.func_174813_aQ().func_72314_b((double)expanded, 0.25, (double)expanded))) {
                    if (aoeTarget == player || aoeTarget == target || aoeTarget instanceof ArmorStandEntity && ((ArmorStandEntity)aoeTarget).func_181026_s() || !ShearsAbilityModifier.shearEntity(stack, tool, world, player, (Entity)aoeTarget, looting)) continue;
                    broken = ToolDamageUtil.damageAnimated(tool, 1, (LivingEntity)player, slotType);
                    ShearsAbilityModifier.runShearHook(tool, player, (Entity)aoeTarget, false);
                    if (!broken) continue;
                    break;
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private static void runShearHook(IModifierToolStack tool, PlayerEntity player, Entity entity, boolean isTarget) {
        for (ModifierEntry entry : tool.getModifierList()) {
            IShearModifier shearModifier = entry.getModifier().getModule(IShearModifier.class);
            if (shearModifier == null) continue;
            shearModifier.afterShearEntity(tool, entry.getLevel(), player, entity, isTarget);
        }
    }

    private static boolean shearEntity(ItemStack itemStack, IModifierToolStack tool, World world, PlayerEntity player, Entity entity, int fortune) {
        IForgeShearable target;
        Event.Result result = new TinkerToolEvent.ToolShearEvent(itemStack, tool, world, player, entity, fortune).fire();
        if (result != Event.Result.DEFAULT) {
            return result == Event.Result.ALLOW;
        }
        if (entity instanceof IForgeShearable && (target = (IForgeShearable)entity).isShearable(itemStack, world, entity.func_233580_cy_())) {
            if (!world.field_72995_K) {
                target.onSheared(player, itemStack, world, entity.func_233580_cy_(), fortune).forEach(stack -> ModifierUtil.dropItem(entity, stack));
            }
            return true;
        }
        return false;
    }

    @Override
    public Boolean removeBlock(IModifierToolStack tool, int level, ToolHarvestContext context) {
        BlockState state = context.getState();
        if (this.isShears(tool) && state.func_177230_c() instanceof TripWireBlock) {
            context.getWorld().func_180501_a(context.getPos(), (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208178_e, (Comparable)Boolean.TRUE), 4);
        }
        return null;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

