/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.slotless;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.IncrementalModifier;
import slimeknights.tconstruct.library.modifiers.data.FloatMultiplier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;

public class FarsightedModifier
extends IncrementalModifier {
    private final ResourceLocation[] SLOT_KEYS = (ResourceLocation[])Arrays.stream(EquipmentSlotType.values()).sorted(Comparator.comparing(EquipmentSlotType::func_188452_c)).map(slot -> TConstruct.getResource("farsighted_" + slot.func_188450_d())).toArray(ResourceLocation[]::new);

    public FarsightedModifier() {
        super(7955825);
    }

    @Override
    public void onEquip(IModifierToolStack tool, int level, EquipmentChangeContext context) {
        if (!tool.isBroken()) {
            ResourceLocation key = this.SLOT_KEYS[context.getChangedSlot().func_188452_c()];
            context.getTinkerData().ifPresent(data -> ((FloatMultiplier)data.computeIfAbsent(TinkerDataKeys.FOV_MODIFIER)).set(key, 1.0f / (1.0f + 0.05f * (float)level)));
        }
    }

    @Override
    public void onUnequip(IModifierToolStack tool, int level, EquipmentChangeContext context) {
        EquipmentSlotType slot = context.getChangedSlot();
        if (!tool.isBroken()) {
            ResourceLocation key = this.SLOT_KEYS[context.getChangedSlot().func_188452_c()];
            context.getTinkerData().ifPresent(data -> ((FloatMultiplier)data.computeIfAbsent(TinkerDataKeys.FOV_MODIFIER)).remove(key));
        }
    }
}

