/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits;

import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;

public class DamageSpeedTradeModifier
extends Modifier {
    private static final ITextComponent MINING_SPEED = TConstruct.makeTranslation("modifier", "fake_attribute.mining_speed");
    private final float multiplier;
    private final Lazy<UUID> uuid = Lazy.of(() -> UUID.nameUUIDFromBytes(this.getId().toString().getBytes()));
    private final Lazy<String> attributeName = Lazy.of(() -> {
        ModifierId id = this.getId();
        return id.func_110623_a() + "." + id.func_110624_b() + ".attack_damage";
    });

    public DamageSpeedTradeModifier(int color, float multiplier) {
        super(color);
        this.multiplier = multiplier;
    }

    private double getMultiplier(IModifierToolStack tool, int level) {
        return Math.sqrt((float)(tool.getDamage() * level) / tool.getModifier(ToolStats.DURABILITY)) * (double)this.multiplier;
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, boolean isAdvanced, boolean detailed) {
        double boost = this.getMultiplier(tool, level);
        if (boost != 0.0 && tool.hasTag((ITag<Item>)TinkerTags.Items.HARVEST)) {
            tooltip.add((ITextComponent)this.applyStyle(new StringTextComponent(Util.PERCENT_BOOST_FORMAT.format(-boost)).func_240702_b_(" ").func_230529_a_(MINING_SPEED)));
        }
    }

    @Override
    public void addAttributes(IModifierToolStack tool, int level, EquipmentSlotType slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        double boost;
        if (slot == EquipmentSlotType.MAINHAND && (boost = this.getMultiplier(tool, level)) != 0.0) {
            consumer.accept(Attributes.field_233823_f_, new AttributeModifier((UUID)this.uuid.get(), (String)this.attributeName.get(), boost / 2.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    @Override
    public void onBreakSpeed(IModifierToolStack tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            event.setNewSpeed((float)((double)event.getNewSpeed() * (1.0 - this.getMultiplier(tool, level))));
        }
    }
}

