/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.general;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.events.teleport.EnderportingTeleportEvent;
import slimeknights.tconstruct.library.modifiers.SingleUseModifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;

public class EnderportingModifier
extends SingleUseModifier {
    private static final Set<SPlayerPositionLookPacket.Flags> PACKET_FLAGS = ImmutableSet.of((Object)SPlayerPositionLookPacket.Flags.X, (Object)SPlayerPositionLookPacket.Flags.Y, (Object)SPlayerPositionLookPacket.Flags.Z);

    public EnderportingModifier() {
        super(11087359);
    }

    @Override
    public int getPriority() {
        return 75;
    }

    private static boolean tryTeleport(LivingEntity living, double x, double y, double z) {
        BiPredicate<BlockState, BlockPos> statePosPredicate;
        float eyeHeight;
        World world = living.func_130014_f_();
        if (world.field_72995_K) {
            return false;
        }
        float scaledWidth = living.func_213311_cf() * 0.8f;
        AxisAlignedBB aabb = AxisAlignedBB.func_241550_g_((double)scaledWidth, (double)(eyeHeight = living.func_70047_e()), (double)scaledWidth).func_72317_d(x, y + (double)(eyeHeight / 2.0f), z);
        boolean didCollide = world.func_241457_a_((Entity)living, aabb, statePosPredicate = (state, pos) -> state.func_229980_m_((IBlockReader)world, pos)).findAny().isPresent();
        if (didCollide && living.func_213302_cg() > 1.0f) {
            aabb = aabb.func_72317_d(0.0, -1.0, 0.0);
            didCollide = world.func_241457_a_((Entity)living, aabb, statePosPredicate).findAny().isPresent();
            y -= 1.0;
        }
        if (!didCollide) {
            EnderportingTeleportEvent event = new EnderportingTeleportEvent(living, x, y, z);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                if (living instanceof ServerPlayerEntity) {
                    ServerPlayerEntity playerMP = (ServerPlayerEntity)living;
                    playerMP.field_71135_a.func_175089_a(x, y, z, playerMP.field_70177_z, playerMP.field_70125_A, PACKET_FLAGS);
                } else {
                    living.func_70107_b(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                }
                if (world instanceof ServerWorld) {
                    ServerWorld serverWorld = (ServerWorld)world;
                    for (int i = 0; i < 32; ++i) {
                        serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197599_J, living.func_226277_ct_(), living.func_226278_cu_() + world.field_73012_v.nextDouble() * 2.0, living.func_226281_cx_(), 1, world.field_73012_v.nextGaussian(), 0.0, world.field_73012_v.nextGaussian(), 0.0);
                    }
                }
                world.func_184148_a(null, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), Sounds.ENDERPORTING.getSound(), living.func_184176_by(), 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    @Override
    public int afterEntityHit(IModifierToolStack tool, int level, ToolAttackContext context, float damageDealt) {
        LivingEntity target;
        if (!context.isExtraAttack() && (target = context.getLivingTarget()) != null && target.func_110143_aJ() == 0.0f) {
            Vector3d pos = target.func_213303_ch();
            if (EnderportingModifier.tryTeleport(context.getAttacker(), pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c())) {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void finishBreakingBlocks(IModifierToolStack tool, int level, ToolHarvestContext context) {
        if (context.canHarvest()) {
            BlockPos pos = context.getPos();
            LivingEntity living = context.getLiving();
            if (EnderportingModifier.tryTeleport(living, (float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f)) {
                ToolDamageUtil.damageAnimated(tool, 2, living);
            }
        }
    }
}

