/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.skull;

import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.library.modifiers.impl.TotalArmorLevelModifier;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffect;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffectLoader;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class StrongBonesModifier
extends TotalArmorLevelModifier {
    public static final SpillingEffect SPILLING_EFFECT = new SpillingEffect();
    public static final ISpillingEffectLoader<SpillingEffect> SPILLING_EFFECT_LOADER = new ISpillingEffectLoader.Singleton<SpillingEffect>(SPILLING_EFFECT);
    private static final TinkerDataCapability.TinkerDataKey<Integer> STRONG_BONES = TConstruct.createKey("strong_bones");
    public static final TinkerDataCapability.TinkerDataKey<Integer> CALCIFIABLE = TConstruct.createKey("calcifable");

    public StrongBonesModifier() {
        super(0xD3D3D3, STRONG_BONES, true);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, LivingEntityUseItemEvent.Finish.class, StrongBonesModifier::onItemFinishUse);
    }

    @Override
    public void onUnequip(IModifierToolStack tool, int level, EquipmentChangeContext context) {
        IModifierToolStack replacement;
        super.onUnequip(tool, level, context);
        if (context.getChangedSlot() == EquipmentSlotType.HEAD && ((replacement = context.getReplacementTool()) == null || replacement.getModifierLevel(this) == 0)) {
            context.getEntity().curePotionEffects(new ItemStack((IItemProvider)tool.getItem()));
        }
    }

    private static void drinkMilk(LivingEntity living, int duration) {
        if (ModifierUtil.getTotalModifierLevel(living, STRONG_BONES) > 0) {
            EffectInstance effect = new EffectInstance(Effects.field_76429_m, duration);
            effect.getCurativeItems().clear();
            effect.getCurativeItems().add(new ItemStack((IItemProvider)living.func_184582_a(EquipmentSlotType.HEAD).func_77973_b()));
            living.func_195064_c(effect);
        }
        if (ModifierUtil.getTotalModifierLevel(living, CALCIFIABLE) > 0) {
            ((TinkerEffect)TinkerModifiers.calcifiedEffect.get()).apply(living, duration, 0, true);
        }
    }

    private static void onItemFinishUse(LivingEntityUseItemEvent.Finish event) {
        LivingEntity living = event.getEntityLiving();
        if (event.getItem().func_77973_b() == Items.field_151117_aB) {
            StrongBonesModifier.drinkMilk(living, 1200);
        }
    }

    public static class SpillingEffect
    implements ISpillingEffect {
        private SpillingEffect() {
        }

        @Override
        public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
            LivingEntity target = context.getLivingTarget();
            if (target != null) {
                StrongBonesModifier.drinkMilk(target, (int)(400.0f * scale));
            }
        }

        @Override
        public ISpillingEffectLoader<?> getLoader() {
            return SPILLING_EFFECT_LOADER;
        }
    }
}

