/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.general;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.Hand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.world.BlockEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ExperiencedModifier
extends Modifier {
    public ExperiencedModifier() {
        super(15260489);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityKill);
        MinecraftForge.EVENT_BUS.addListener(this::beforeBlockBreak);
    }

    private static int boost(int original, int level) {
        return (int)((double)original * (1.0 + 0.5 * (double)level));
    }

    private void beforeBlockBreak(BlockEvent.BreakEvent event) {
        int level = 0;
        ToolStack tool = ExperiencedModifier.getHeldTool((LivingEntity)event.getPlayer(), Hand.MAIN_HAND);
        if (tool != null) {
            level = tool.getModifierLevel(this);
        }
        if ((tool = ExperiencedModifier.getHeldTool((LivingEntity)event.getPlayer(), EquipmentSlotType.LEGS)) != null) {
            level += tool.getModifierLevel(this);
        }
        if (level > 0) {
            event.setExpToDrop(ExperiencedModifier.boost(event.getExpToDrop(), level));
        }
    }

    private void onEntityKill(LivingExperienceDropEvent event) {
        PlayerEntity player = event.getAttackingPlayer();
        if (player != null) {
            int level = 0;
            ToolStack tool = ExperiencedModifier.getHeldTool((LivingEntity)player, ModifierLootingHandler.getLootingSlot((LivingEntity)player));
            if (tool != null) {
                level = tool.getModifierLevel(this);
            }
            if ((tool = ExperiencedModifier.getHeldTool((LivingEntity)player, EquipmentSlotType.LEGS)) != null) {
                level += tool.getModifierLevel(this);
            }
            if (level > 0) {
                event.setDroppedExperience(ExperiencedModifier.boost(event.getDroppedExperience(), level));
            }
        }
    }
}

