/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.stats;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.tools.stat.ToolStatsBuilder;
import slimeknights.tconstruct.tools.stats.SkullStats;

public class SkullToolStatsBuilder
extends ToolStatsBuilder {
    private final List<SkullStats> skulls;

    @VisibleForTesting
    protected SkullToolStatsBuilder(ToolDefinitionData toolData, List<SkullStats> skulls) {
        super(toolData);
        this.skulls = skulls;
    }

    public static ToolStatsBuilder from(ToolDefinition toolDefinition, List<IMaterial> materials) {
        ToolDefinitionData data = toolDefinition.getData();
        List<PartRequirement> requiredComponents = data.getParts();
        if (materials.size() != requiredComponents.size()) {
            return ToolStatsBuilder.noParts(toolDefinition);
        }
        return new SkullToolStatsBuilder(data, SkullToolStatsBuilder.listOfCompatibleWith(SkullStats.ID, materials, requiredComponents));
    }

    @Override
    protected void setStats(StatsNBT.Builder builder) {
        builder.set(ToolStats.DURABILITY, this.buildDurability());
        builder.set(ToolStats.ARMOR, this.buildArmor());
    }

    @Override
    protected boolean handles(IToolStat<?> stat) {
        return stat == ToolStats.DURABILITY || stat == ToolStats.ARMOR;
    }

    public float buildDurability() {
        return Math.max(1.0f, (float)SkullToolStatsBuilder.getAverageValue(this.skulls, SkullStats::getDurability) + this.toolData.getBonus(ToolStats.DURABILITY));
    }

    public float buildArmor() {
        return Math.max(0.0f, (float)SkullToolStatsBuilder.getAverageValue(this.skulls, SkullStats::getArmor) + this.toolData.getBonus(ToolStats.ARMOR));
    }
}

