/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.server.ServerWorld;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.block.SlimeGrassBlock;

public class SlimeNyliumBlock
extends Block
implements IGrowable {
    private final SlimeType foliageType;

    public SlimeNyliumBlock(AbstractBlock.Properties properties, SlimeType foliageType) {
        super(properties);
        this.foliageType = foliageType;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.foliageType != SlimeType.ICHOR) {
            super.func_149666_a(group, items);
        }
    }

    private static boolean isDarkEnough(BlockState state, IWorldReader reader, BlockPos pos) {
        BlockPos blockpos = pos.func_177984_a();
        BlockState blockstate = reader.func_180495_p(blockpos);
        int i = LightEngine.func_215613_a((IBlockReader)reader, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.func_200016_a((IBlockReader)reader, blockpos));
        return i < reader.func_201572_C();
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!SlimeNyliumBlock.isDarkEnough(state, (IWorldReader)worldIn, pos)) {
            worldIn.func_175656_a(pos, SlimeGrassBlock.getDirtState(state));
        }
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return worldIn.func_180495_p(pos.func_177984_a()).func_196958_f();
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        SlimeGrassBlock.growGrass(world, rand, pos, TinkerTags.Blocks.SLIMY_NYLIUM, this.foliageType, true, true);
    }
}

