/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks;

import com.dannyandson.tinyredstone.gui.ChopperItemHandler;
import com.dannyandson.tinyredstone.gui.ChopperMenu;
import com.dannyandson.tinyredstone.setup.Registration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ChopperBlockEntity
extends LockableLootTileEntity {
    private NonNullList<ItemStack> items;
    private CraftResultInventory resultContainer = new CraftResultInventory();
    private ChopperMenu chopperMenu;
    private final ChopperItemHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private String itemType = "Tiny Block";

    public ChopperBlockEntity() {
        super((TileEntityType)Registration.CUTTER_BLOCK_ENTITY.get());
        this.items = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    }

    public void setCutterMenu(ChopperMenu chopperMenu) {
        this.chopperMenu = chopperMenu;
    }

    public void func_70296_d() {
        if (this.chopperMenu != null && !this.field_145850_b.field_72995_K) {
            this.chopperMenu.func_75130_a((IInventory)this);
        }
        super.func_70296_d();
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.tinyredstone.block_chopper");
    }

    @Nullable
    public Container func_213906_a(int containerId, PlayerInventory playerInventory) {
        return ChopperMenu.createChopperMenu(containerId, playerInventory, (IInventory)this);
    }

    public int func_70302_i_() {
        return 1;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    protected void func_199721_a(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public CraftResultInventory getResultContainer() {
        return this.resultContainer;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compoundTag) {
        super.func_230337_a_(blockState, compoundTag);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.items.set(0, (Object)ItemStack.func_199557_a((CompoundNBT)compoundTag.func_74775_l("input_container")));
        this.resultContainer.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)compoundTag.func_74775_l("output_container")));
        this.itemType = compoundTag.func_74779_i("output_type");
    }

    public CompoundNBT func_189515_b(CompoundNBT compoundTag) {
        super.func_189515_b(compoundTag);
        compoundTag.func_218657_a("input_container", (INBT)((ItemStack)this.items.get(0)).serializeNBT());
        compoundTag.func_218657_a("output_container", (INBT)this.resultContainer.func_70301_a(0).serializeNBT());
        compoundTag.func_74778_a("output_type", this.itemType);
        return compoundTag;
    }

    private ChopperItemHandler createHandler() {
        return new ChopperItemHandler(this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.handler.invalidate();
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
        if (this.chopperMenu != null) {
            this.chopperMenu.func_75130_a(null);
        }
    }
}

