/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IObservingPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.LinkedList;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class Observer
implements IPanelCell,
IObservingPanelCell {
    public static ResourceLocation TEXTURE_OBSERVER_TOP = new ResourceLocation("minecraft", "block/observer_top");
    public static ResourceLocation TEXTURE_OBSERVER_BACK_ON = new ResourceLocation("minecraft", "block/observer_back_on");
    public static ResourceLocation TEXTURE_OBSERVER_BACK = new ResourceLocation("minecraft", "block/observer_back");
    public static ResourceLocation TEXTURE_OBSERVER_FRONT = new ResourceLocation("minecraft", "block/observer_front");
    public static ResourceLocation TEXTURE_OBSERVER_SIDE = new ResourceLocation("minecraft", "block/observer_side");
    boolean output = false;
    private LinkedList<Boolean> queue = new LinkedList();
    private int changedTick = -1;

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, float alpha) {
        IVertexBuilder builder = buffer.getBuffer((double)alpha == 1.0 ? RenderType.func_228639_c_() : RenderType.func_228645_f_());
        TextureAtlasSprite sprite_top = RenderHelper.getSprite(TEXTURE_OBSERVER_TOP);
        TextureAtlasSprite sprite_back = this.output ? RenderHelper.getSprite(TEXTURE_OBSERVER_BACK_ON) : RenderHelper.getSprite(TEXTURE_OBSERVER_BACK);
        TextureAtlasSprite sprite_front = RenderHelper.getSprite(TEXTURE_OBSERVER_FRONT);
        TextureAtlasSprite sprite_side = RenderHelper.getSprite(TEXTURE_OBSERVER_SIDE);
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        this.addRectangle(builder, matrixStack, sprite_top, combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        this.addRectangle(builder, matrixStack, sprite_front, combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        this.addRectangle(builder, matrixStack, sprite_side, combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        this.addRectangle(builder, matrixStack, sprite_back, combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        this.addRectangle(builder, matrixStack, sprite_side, combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
        matrixStack.func_227861_a_(-1.0, 0.0, 1.0);
        this.addRectangle(builder, matrixStack, sprite_top, combinedLight, alpha);
    }

    private void addRectangle(IVertexBuilder builder, MatrixStack matrixStack, TextureAtlasSprite sprite, int combinedLight, float alpha) {
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, alpha);
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        return false;
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        return outputDirection == Side.BACK && this.output ? 15 : 0;
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        return this.getWeakRsOutput(outputDirection);
    }

    @Override
    public boolean isIndependentState() {
        return true;
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    @Override
    public boolean canPlaceVertical() {
        return true;
    }

    @Override
    public boolean tick(PanelCellPos cellPos) {
        if (this.changedTick > -1 && this.changedTick < cellPos.getPanelTile().getRelTickTime()) {
            this.frontNeighborUpdated();
            this.changedTick = -1;
        }
        boolean change = false;
        if (this.queue.size() > 0) {
            change = this.setOutput(this.queue.remove());
        } else if (this.output) {
            this.output = false;
            change = true;
        }
        if (this.changedTick > -1) {
            this.frontNeighborUpdated();
            this.changedTick = -1;
        }
        return change;
    }

    private boolean setOutput(boolean output) {
        if (this.output != output) {
            this.output = output;
            return true;
        }
        return false;
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("output", this.output);
        String queueString = "";
        boolean i = false;
        for (Object b : this.queue.toArray()) {
            queueString = queueString + ((Boolean)b != false ? "1" : "0");
        }
        nbt.func_74778_a("queue", queueString);
        nbt.func_74768_a("changedTick", this.changedTick);
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT compoundNBT) {
        this.output = compoundNBT.func_74767_n("output");
        String queueString = compoundNBT.func_74779_i("queue");
        byte[] byArray = queueString.getBytes();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte b = byArray[i];
            this.queue.add(b == 49);
        }
        this.changedTick = compoundNBT.func_74762_e("changedTick");
    }

    @Override
    public boolean frontNeighborUpdated(PanelCellPos cellPos) {
        this.changedTick = cellPos.getPanelTile().getRelTickTime();
        return false;
    }

    private void frontNeighborUpdated() {
        if (this.queue.isEmpty()) {
            this.queue.add(false);
            this.queue.add(true);
            this.queue.add(true);
        }
    }
}

