/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.Config;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellVoxelShape;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.RotationLock;
import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.LinkedList;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class Torch
implements IPanelCell {
    private boolean output = true;
    private int changePending = 0;
    private final LinkedList<Boolean> changeHx = new LinkedList();
    private boolean burnout = false;
    private boolean upright = false;
    private Side baseSide = Side.BOTTOM;
    private int changedTick = -1;
    public static ResourceLocation TEXTURE_TORCH_ON = new ResourceLocation("tinyredstone", "block/redstone_torch");
    public static ResourceLocation TEXTURE_TORCH_OFF = new ResourceLocation("tinyredstone", "block/redstone_torch_off");
    public static ResourceLocation TEXTURE_TORCH_TOP_ON = new ResourceLocation("tinyredstone", "block/redstone_torch_top");
    public static ResourceLocation TEXTURE_TORCH_TOP_OFF = new ResourceLocation("tinyredstone", "block/redstone_torch_top_off");

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, float alpha) {
        TextureAtlasSprite sprite_torch_top;
        TextureAtlasSprite sprite_torch;
        IVertexBuilder builder = buffer.getBuffer((double)alpha == 1.0 ? RenderType.func_228639_c_() : RenderType.func_228645_f_());
        if (this.getWeakRsOutput(Side.FRONT) > 0) {
            sprite_torch = RenderHelper.getSprite(TEXTURE_TORCH_ON);
            sprite_torch_top = RenderHelper.getSprite(TEXTURE_TORCH_TOP_ON);
        } else {
            sprite_torch = RenderHelper.getSprite(TEXTURE_TORCH_OFF);
            sprite_torch_top = RenderHelper.getSprite(TEXTURE_TORCH_TOP_OFF);
        }
        float x1 = 0.375f;
        float x2 = 0.625f;
        float y1 = 0.0f;
        float y2 = 1.0f;
        if (this.upright) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            matrixStack.func_227861_a_(0.0, 0.0, -0.375);
        } else if (this.baseSide == Side.FRONT) {
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            matrixStack.func_227861_a_(-1.0, -1.125, 0.125);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(60.0f));
        } else {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(60.0f));
            matrixStack.func_227861_a_(0.0, 0.03125, 0.0);
        }
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, sprite_torch, this.output ? 0xF000F0 : combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_((double)(-x1), 0.0, (double)x2);
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, sprite_torch, this.output ? 0xF000F0 : combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_((double)(-x1), 0.0, (double)x2);
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, sprite_torch, this.output ? 0xF000F0 : combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_((double)(-x1), 0.0, (double)x2);
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, sprite_torch, this.output ? 0xF000F0 : combinedLight, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
        matrixStack.func_227861_a_(0.0, (double)(-x1), (double)y2);
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, x1, x2, sprite_torch_top, this.output ? 0xF000F0 : combinedLight, alpha);
    }

    @Override
    public boolean onPlace(PanelCellPos cellPos, PlayerEntity player) {
        if (RotationLock.getServerRotationLock(player) == null) {
            double playerToPanel;
            Direction panelFacing = (Direction)cellPos.getPanelTile().func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
            switch (panelFacing) {
                case NORTH: {
                    playerToPanel = -player.func_70040_Z().field_72449_c;
                    break;
                }
                case SOUTH: {
                    playerToPanel = player.func_70040_Z().field_72449_c;
                    break;
                }
                case WEST: {
                    playerToPanel = -player.func_70040_Z().field_72450_a;
                    break;
                }
                case EAST: {
                    playerToPanel = player.func_70040_Z().field_72450_a;
                    break;
                }
                case UP: {
                    playerToPanel = player.func_70040_Z().field_72448_b;
                    break;
                }
                default: {
                    playerToPanel = -player.func_70040_Z().field_72448_b;
                }
            }
            if (playerToPanel > 0.95) {
                this.upright = true;
            }
        }
        this.neighborChanged(cellPos);
        return true;
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        this.changedTick = cellPos.getPanelTile().getRelTickTime();
        return false;
    }

    private void checkInputs(PanelCellPos cellPos) {
        boolean output;
        PanelCellNeighbor inputNeighbor = cellPos.getNeighbor(this.baseSide == Side.FRONT ? Side.FRONT : (this.upright ? Side.BOTTOM : Side.BACK));
        boolean bl = output = inputNeighbor == null || inputNeighbor.getWeakRsOutput() == 0;
        if (this.burnout && output) {
            int changes = 0;
            for (Boolean b : this.changeHx) {
                if (!b.booleanValue()) continue;
                ++changes;
            }
            if (changes <= 16) {
                this.burnout = false;
            }
            this.changePending = 2;
        }
        if (!this.burnout && output != this.output) {
            this.output = output;
            this.changePending = 2;
        }
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        if (!this.burnout && (this.baseSide == Side.FRONT && outputDirection != Side.FRONT || !this.upright && outputDirection != Side.BACK || this.upright && outputDirection != Side.BOTTOM) && (this.output && this.changePending == 0 || !this.output && this.changePending > 0)) {
            return 15;
        }
        return 0;
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        if (outputDirection == Side.TOP && !this.burnout && (this.output && this.changePending == 0 || !this.output && this.changePending > 0)) {
            return 15;
        }
        return 0;
    }

    @Override
    public int lightOutput() {
        return (Boolean)Config.TORCH_LIGHT.get() != false && this.getWeakRsOutput(Side.FRONT) > 0 ? 1 : 0;
    }

    @Override
    public boolean tick(PanelCellPos cellPos) {
        if (this.changedTick > -1 && this.changedTick < cellPos.getPanelTile().getRelTickTime()) {
            this.checkInputs(cellPos);
            this.changedTick = -1;
        }
        boolean changed = false;
        this.changeHx.add(this.changePending == 2);
        if (this.changeHx.size() > 60) {
            this.changeHx.pop();
        }
        int changes = 0;
        for (Boolean b : this.changeHx) {
            if (!b.booleanValue()) continue;
            ++changes;
        }
        if (changes > 16) {
            this.burnout = true;
        }
        if (this.changePending > 1) {
            --this.changePending;
        } else if (this.changePending == 1) {
            --this.changePending;
            changed = true;
        }
        if (this.changedTick > -1) {
            this.checkInputs(cellPos);
            this.changedTick = -1;
        }
        return changed;
    }

    @Override
    public boolean needsSolidBase() {
        return true;
    }

    @Override
    public boolean canAttachToBaseOnSide(Side side) {
        return side != Side.TOP;
    }

    @Override
    public Side getBaseSide() {
        return this.baseSide;
    }

    @Override
    public void setBaseSide(Side side) {
        this.baseSide = side;
        if (side == Side.FRONT) {
            this.upright = false;
        }
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("output", this.output);
        nbt.func_74768_a("changePending", this.changePending);
        nbt.func_74757_a("burnout", this.burnout);
        nbt.func_74757_a("upright", this.upright);
        nbt.func_74778_a("baseSide", this.baseSide.name());
        StringBuilder changeHxString = new StringBuilder();
        for (Object b : this.changeHx.toArray()) {
            changeHxString.append((Boolean)b != false ? "1" : "0");
        }
        nbt.func_74778_a("changeHx", changeHxString.toString());
        nbt.func_74768_a("changedTick", this.changedTick);
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT compoundNBT) {
        this.output = compoundNBT.func_74767_n("output");
        this.changePending = compoundNBT.func_74762_e("changePending");
        this.burnout = compoundNBT.func_74767_n("burnout");
        this.upright = compoundNBT.func_74767_n("upright");
        this.baseSide = compoundNBT.func_74779_i("baseSide").length() > 0 ? Side.valueOf(compoundNBT.func_74779_i("baseSide")) : Side.BOTTOM;
        String changeHxString = compoundNBT.func_74779_i("changeHx");
        byte[] byArray = changeHxString.getBytes();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte b = byArray[i];
            this.changeHx.add(b == 49);
            if (this.changeHx.size() <= 60) continue;
            this.changeHx.pop();
        }
        this.changedTick = compoundNBT.func_74762_e("changedTick");
    }

    @Override
    public PanelCellVoxelShape getShape() {
        return new PanelCellVoxelShape(new Vector3d(0.25, 0.0, 0.25), new Vector3d(0.75, 1.0, 0.75));
    }
}

