/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.codec;

import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import net.minecraft.util.ResourceLocation;

public class TinyBlockData {
    public static List<String> validBlockTextureCache = new ArrayList<String>();
    private List<Pair<String, List<Pair<String, String>>>> data;
    private Map<String, Map<String, String>> tinyBlockDefinitions = new HashMap<String, Map<String, String>>();
    public static final Codec<TinyBlockData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.compoundList((Codec)Codec.STRING, (Codec)Codec.compoundList((Codec)Codec.STRING, (Codec)Codec.STRING)).fieldOf("tiny_block_definitions").forGetter(o -> o.data)).apply((Applicative)instance, TinyBlockData::new));

    public TinyBlockData(List<Pair<String, List<Pair<String, String>>>> definitions) {
        this.data = definitions;
        for (Pair<String, List<Pair<String, String>>> itemData : this.data) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (Pair itemPair : (List)itemData.getSecond()) {
                map.put(itemPair.getFirst(), itemPair.getSecond());
            }
            this.tinyBlockDefinitions.put((String)itemData.getFirst(), map);
        }
    }

    @CheckForNull
    public ResourceLocation getTexture(ResourceLocation itemResourceId) {
        return this.getTexture(itemResourceId, Side.FRONT);
    }

    public ResourceLocation getTexture(ResourceLocation itemResourceId, Side side) {
        if (this.tinyBlockDefinitions.containsKey(itemResourceId.toString())) {
            Map<String, String> itemData = this.tinyBlockDefinitions.get(itemResourceId.toString());
            if (side == Side.FRONT) {
                if (itemData.containsKey("texture_front")) {
                    return TinyBlockData.textureResourceLocationFromResourceId(itemData.get("texture_front"));
                }
                if (itemData.containsKey("texture_side")) {
                    return TinyBlockData.textureResourceLocationFromResourceId(itemData.get("texture_side"));
                }
            } else if (side == Side.TOP) {
                if (itemData.containsKey("texture_top")) {
                    return TinyBlockData.textureResourceLocationFromResourceId(itemData.get("texture_top"));
                }
            } else if (side == Side.BOTTOM) {
                if (itemData.containsKey("texture_bottom")) {
                    return TinyBlockData.textureResourceLocationFromResourceId(itemData.get("texture_bottom"));
                }
            } else if (side == Side.LEFT) {
                if (itemData.containsKey("texture_left")) {
                    return TinyBlockData.textureResourceLocationFromResourceId(itemData.get("texture_left"));
                }
                if (itemData.containsKey("texture_side")) {
                    return TinyBlockData.textureResourceLocationFromResourceId(itemData.get("texture_side"));
                }
            } else if (side == Side.RIGHT) {
                if (itemData.containsKey("texture_right")) {
                    return TinyBlockData.textureResourceLocationFromResourceId(itemData.get("texture_right"));
                }
                if (itemData.containsKey("texture_side")) {
                    return TinyBlockData.textureResourceLocationFromResourceId(itemData.get("texture_side"));
                }
            } else if (side == Side.BACK) {
                if (itemData.containsKey("texture_back")) {
                    return TinyBlockData.textureResourceLocationFromResourceId(itemData.get("texture_back"));
                }
                if (itemData.containsKey("texture_side")) {
                    return TinyBlockData.textureResourceLocationFromResourceId(itemData.get("texture_side"));
                }
            }
            if (itemData.containsKey("texture")) {
                return TinyBlockData.textureResourceLocationFromResourceId(itemData.get("texture"));
            }
        }
        return null;
    }

    @CheckForNull
    public String getType(ResourceLocation itemResourceId) {
        Map<String, String> itemData;
        if (this.tinyBlockDefinitions.containsKey(itemResourceId.toString()) && (itemData = this.tinyBlockDefinitions.get(itemResourceId.toString())).containsKey("type")) {
            return itemData.get("type");
        }
        return null;
    }

    @CheckForNull
    protected static ResourceLocation textureResourceLocationFromResourceId(String resourceId) {
        String[] resourceIdStrings = resourceId.split(":");
        if (resourceIdStrings.length == 1) {
            return new ResourceLocation("minecraft", "block/" + resourceIdStrings[0]);
        }
        if (resourceIdStrings.length == 2) {
            return new ResourceLocation(resourceIdStrings[0], "block/" + resourceIdStrings[1]);
        }
        return null;
    }
}

