/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.compat.hwyla;

import com.dannyandson.tinyredstone.Config;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelBlock;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.compat.CompatHandler;
import com.dannyandson.tinyredstone.compat.hwyla.OverlayBlockInfo;
import com.dannyandson.tinyredstone.compat.hwyla.TooltipRendererInfoString;
import com.dannyandson.tinyredstone.compat.hwyla.TooltipRendererItemStackInline;
import com.dannyandson.tinyredstone.compat.hwyla.TooltipRendererString;
import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltipRenderer;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.RenderableTextComponent;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.loading.FMLEnvironment;

@WailaPlugin(value="tinyredstone")
public class PanelProvider
implements IWailaPlugin,
IComponentProvider {
    static final ResourceLocation RENDER_STRING = new ResourceLocation("string");
    static final ResourceLocation RENDER_ITEM_INLINE = new ResourceLocation("item_inline");
    static final ResourceLocation RENDER_INFO_STRING = new ResourceLocation("info_string");

    public void register(IRegistrar registrar) {
        if (FMLEnvironment.dist.isClient()) {
            registrar.registerTooltipRenderer(RENDER_STRING, (ITooltipRenderer)new TooltipRendererString());
            registrar.registerTooltipRenderer(RENDER_ITEM_INLINE, (ITooltipRenderer)new TooltipRendererItemStackInline());
            registrar.registerTooltipRenderer(RENDER_INFO_STRING, (ITooltipRenderer)new TooltipRendererInfoString());
        }
        registrar.registerComponentProvider((IComponentProvider)this, TooltipPosition.BODY, PanelBlock.class);
    }

    private boolean show(PlayerEntity playerEntity) {
        switch ((Integer)Config.DISPLAY_MODE.get()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return playerEntity.func_213453_ef();
            }
            case 3: {
                return CompatHandler.isMeasuringDevice(playerEntity.func_184614_ca().func_77973_b());
            }
            case 4: {
                return CompatHandler.isTinyComponent(playerEntity.func_184614_ca().func_77973_b());
            }
        }
        return true;
    }

    public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
        if (accessor.getBlock() != null) {
            BlockPos pos = accessor.getPosition();
            World world = accessor.getWorld();
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof PanelTile && this.show(accessor.getPlayer())) {
                PanelTile panelTile = (PanelTile)tileEntity;
                Block block = accessor.getBlock();
                if (!panelTile.isCovered() && block instanceof PanelBlock) {
                    PanelBlock panelBlock = (PanelBlock)block;
                    BlockRayTraceResult result = panelTile.getPlayerCollisionHitResult(accessor.getPlayer());
                    PanelCellPos panelCellPos = PanelCellPos.fromHitVec(panelTile, (Direction)accessor.getBlockState().func_177229_b((Property)BlockStateProperties.field_208155_H), result);
                    if (panelCellPos != null && panelCellPos.getIPanelCell() != null) {
                        IPanelCell panelCell = panelCellPos.getIPanelCell();
                        Item item = panelBlock.getItemByIPanelCell(panelCell.getClass());
                        return item.func_190903_i();
                    }
                }
            }
        }
        return super.getStack(accessor, config);
    }

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (accessor.getBlock() != null) {
            BlockPos pos = accessor.getPosition();
            TileEntity tileEntity = accessor.getWorld().func_175625_s(pos);
            if (tileEntity instanceof PanelTile && this.show(accessor.getPlayer())) {
                PanelTile panelTile = (PanelTile)tileEntity;
                if (!panelTile.isCovered()) {
                    BlockRayTraceResult rtr = panelTile.getPlayerCollisionHitResult(accessor.getPlayer());
                    PosInPanelCell posInPanelCell = PosInPanelCell.fromHitVec(panelTile, pos, rtr);
                    if (posInPanelCell != null) {
                        IPanelCell panelCell = posInPanelCell.getIPanelCell();
                        if (panelCell != null) {
                            Side sideHit;
                            int power;
                            boolean handled = false;
                            if (panelCell instanceof IPanelCellInfoProvider) {
                                OverlayBlockInfo overlayBlockInfo = new OverlayBlockInfo(tooltip, accessor.getPlayer().func_213453_ef());
                                ((IPanelCellInfoProvider)((Object)panelCell)).addInfo(overlayBlockInfo, panelTile, posInPanelCell);
                                if (overlayBlockInfo.power > -1) {
                                    handled = true;
                                    if (overlayBlockInfo.power > 0) {
                                        tooltip.add((ITextComponent)new RenderableTextComponent(new RenderableTextComponent[]{PanelProvider.getItemStackRenderable(new ItemStack((IItemProvider)Items.field_151137_ax)), PanelProvider.getStringRenderable("Power: " + overlayBlockInfo.power)}));
                                    }
                                }
                            }
                            if (!handled && (power = panelCell.getWeakRsOutput(sideHit = panelTile.getPanelCellSide((PanelCellPos)posInPanelCell, panelTile.getSideFromDirection(accessor.getSide())))) > 0) {
                                tooltip.add((ITextComponent)new RenderableTextComponent(new RenderableTextComponent[]{PanelProvider.getItemStackRenderable(new ItemStack((IItemProvider)Items.field_151137_ax)), PanelProvider.getStringRenderable("Power: " + power)}));
                            }
                        }
                    } else {
                        PanelProvider.showBlockRedstonePower(tooltip, accessor.getWorld(), pos, accessor.getSide());
                    }
                } else {
                    PanelProvider.showBlockRedstonePower(tooltip, accessor.getWorld(), pos, accessor.getSide());
                }
            }
        }
    }

    private static void showBlockRedstonePower(List<ITextComponent> tooltip, World world, BlockPos pos, Direction sideHit) {
        PanelProvider.showRedstonePower(tooltip, world.func_175651_c(pos, sideHit.func_176734_d()));
    }

    private static void showRedstonePower(List<ITextComponent> tooltip, int power) {
        if (power > 0) {
            tooltip.add((ITextComponent)new RenderableTextComponent(new RenderableTextComponent[]{PanelProvider.getItemStackRenderable(new ItemStack((IItemProvider)Items.field_151137_ax)), PanelProvider.getStringRenderable("Power: " + power)}));
        }
    }

    public static RenderableTextComponent getItemStackRenderable(ItemStack itemStack) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("id", itemStack.func_77973_b().getRegistryName().toString());
        return new RenderableTextComponent(RENDER_ITEM_INLINE, tag);
    }

    public static RenderableTextComponent getStringRenderable(String string) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("string", string);
        return new RenderableTextComponent(RENDER_STRING, tag);
    }

    public static RenderableTextComponent getInfoStringRenderable(String string) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("string", string);
        return new RenderableTextComponent(RENDER_INFO_STRING, tag);
    }
}

