/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.network;

import com.dannyandson.tinyredstone.blocks.PanelTile;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlaySound {
    private final BlockPos pos;
    private final String namespace;
    private final String path;
    private final float volume;
    private final float pitch;

    public PlaySound(BlockPos pos, String namespace, String path, float volume, float pitch) {
        this.pos = pos;
        this.namespace = namespace;
        this.path = path;
        this.volume = volume;
        this.pitch = pitch;
    }

    public PlaySound(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.namespace = buffer.func_218666_n();
        this.path = buffer.func_218666_n();
        this.volume = buffer.readFloat();
        this.pitch = buffer.readFloat();
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_180714_a(this.namespace);
        buf.func_180714_a(this.path);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(this.pos);
            if (te instanceof PanelTile) {
                te.func_145831_w().func_184134_a((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p(), new SoundEvent(new ResourceLocation(this.namespace, this.path)), SoundCategory.BLOCKS, this.volume, this.pitch, false);
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        return true;
    }
}

