/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.network;

import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.panelcells.Repeater;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class RepeaterTickSync {
    private final BlockPos pos;
    private final int cellIndex;
    private final int ticks;

    public RepeaterTickSync(BlockPos pos, int cellIndex, int ticks) {
        this.pos = pos;
        this.cellIndex = cellIndex;
        this.ticks = ticks;
    }

    public RepeaterTickSync(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.cellIndex = buffer.readInt();
        this.ticks = buffer.readInt();
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeInt(this.cellIndex);
        buf.writeInt(this.ticks);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PanelCellPos cellPos;
            IPanelCell cell;
            TileEntity te = ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q().func_175625_s(this.pos);
            if (te instanceof PanelTile && (cell = (cellPos = PanelCellPos.fromIndex((PanelTile)te, this.cellIndex)).getIPanelCell()) instanceof Repeater) {
                ((Repeater)cell).setTicks(this.ticks);
                ((PanelTile)te).flagSync();
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        return true;
    }
}

