/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.network.client;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import tschipp.carryon.common.scripting.ScriptChecker;
import tschipp.carryon.proxy.ClientProxy;

public class CarrySlotPacket {
    public int slot;
    public int carryOverride = 0;
    public int entityid;

    public CarrySlotPacket(ByteBuf buf) {
        this.slot = buf.readInt();
        this.carryOverride = buf.readInt();
        this.entityid = buf.readInt();
    }

    public CarrySlotPacket(int slot, int entityid) {
        this.slot = slot;
        this.entityid = entityid;
    }

    public CarrySlotPacket(int slot, int entityid, int carryOverride) {
        this.slot = slot;
        this.carryOverride = carryOverride;
        this.entityid = entityid;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
        buf.writeInt(this.carryOverride);
        buf.writeInt(this.entityid);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Entity e;
                World world = ClientProxy.getWorld();
                if (world != null && (e = world.func_73045_a(this.entityid)) != null && e instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)e;
                    ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
                    if (this.slot >= 9) {
                        player.getPersistentData().func_82580_o("carrySlot");
                        player.getPersistentData().func_82580_o("overrideKey");
                    } else {
                        player.getPersistentData().func_74768_a("carrySlot", this.slot);
                        if (this.carryOverride != 0) {
                            ScriptChecker.setCarryOnOverride(player, this.carryOverride);
                        }
                    }
                }
            });
        }
    }
}

