/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.energy;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface IEnergyContainer
extends INBTSerializable<CompoundNBT>,
IContentsListener {
    public FloatingLong getEnergy();

    public void setEnergy(FloatingLong var1);

    default public FloatingLong insert(FloatingLong amount, Action action, AutomationType automationType) {
        if (amount.isZero()) {
            return amount;
        }
        FloatingLong needed = this.getNeeded();
        if (needed.isZero()) {
            return amount;
        }
        FloatingLong toAdd = amount.min(needed);
        if (!toAdd.isZero() && action.execute()) {
            this.setEnergy(this.getEnergy().add(toAdd));
        }
        return amount.subtract(toAdd);
    }

    default public FloatingLong extract(FloatingLong amount, Action action, AutomationType automationType) {
        if (this.isEmpty() || amount.isZero()) {
            return FloatingLong.ZERO;
        }
        FloatingLong ret = this.getEnergy().min(amount).copy();
        if (!ret.isZero() && action.execute()) {
            this.setEnergy(this.getEnergy().subtract(ret));
        }
        return ret;
    }

    public FloatingLong getMaxEnergy();

    default public boolean isEmpty() {
        return this.getEnergy().isZero();
    }

    default public void setEmpty() {
        this.setEnergy(FloatingLong.ZERO);
    }

    default public FloatingLong getNeeded() {
        return FloatingLong.ZERO.max(this.getMaxEnergy().subtract(this.getEnergy()));
    }

    default public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (!this.isEmpty()) {
            nbt.func_74778_a("stored", this.getEnergy().toString());
        }
        return nbt;
    }
}

