/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.energy;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.ISidedStrictEnergyHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import net.minecraft.util.Direction;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface IMekanismStrictEnergyHandler
extends ISidedStrictEnergyHandler,
IContentsListener {
    default public boolean canHandleEnergy() {
        return true;
    }

    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction var1);

    @Nullable
    default public IEnergyContainer getEnergyContainer(int container, @Nullable Direction side) {
        List<IEnergyContainer> containers = this.getEnergyContainers(side);
        return container >= 0 && container < containers.size() ? containers.get(container) : null;
    }

    @Override
    default public int getEnergyContainerCount(@Nullable Direction side) {
        return this.getEnergyContainers(side).size();
    }

    @Override
    default public FloatingLong getEnergy(int container, @Nullable Direction side) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        return energyContainer == null ? FloatingLong.ZERO : energyContainer.getEnergy();
    }

    @Override
    default public void setEnergy(int container, FloatingLong energy, @Nullable Direction side) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        if (energyContainer != null) {
            energyContainer.setEnergy(energy);
        }
    }

    @Override
    default public FloatingLong getMaxEnergy(int container, @Nullable Direction side) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        return energyContainer == null ? FloatingLong.ZERO : energyContainer.getMaxEnergy();
    }

    @Override
    default public FloatingLong getNeededEnergy(int container, @Nullable Direction side) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        return energyContainer == null ? FloatingLong.ZERO : energyContainer.getNeeded();
    }

    @Override
    default public FloatingLong insertEnergy(int container, FloatingLong amount, @Nullable Direction side, Action action) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        return energyContainer == null ? amount : energyContainer.insert(amount, action, side == null ? AutomationType.INTERNAL : AutomationType.EXTERNAL);
    }

    @Override
    default public FloatingLong extractEnergy(int container, FloatingLong amount, @Nullable Direction side, Action action) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        return energyContainer == null ? FloatingLong.ZERO : energyContainer.extract(amount, action, side == null ? AutomationType.INTERNAL : AutomationType.EXTERNAL);
    }
}

