/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ElectrolysisCachedRecipe
extends CachedRecipe<ElectrolysisRecipe> {
    private final IOutputHandler<@NonNull Pair<GasStack, GasStack>> outputHandler;
    private final IInputHandler<@NonNull FluidStack> inputHandler;
    private FluidStack recipeFluid = FluidStack.EMPTY;

    public ElectrolysisCachedRecipe(ElectrolysisRecipe recipe, IInputHandler<@NonNull FluidStack> inputHandler, IOutputHandler<@NonNull Pair<GasStack, GasStack>> outputHandler) {
        super(recipe);
        this.inputHandler = Objects.requireNonNull(inputHandler, "Input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        this.recipeFluid = this.inputHandler.getRecipeInput(((ElectrolysisRecipe)this.recipe).getInput());
        if (this.recipeFluid.isEmpty()) {
            return -1;
        }
        if ((currentMax = this.inputHandler.operationsCanSupport(this.recipeFluid, currentMax)) <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((ElectrolysisRecipe)this.recipe).getOutput(this.recipeFluid), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((ElectrolysisRecipe)this.recipe).test(this.inputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        if (this.recipeFluid.isEmpty()) {
            return;
        }
        this.inputHandler.use(this.recipeFluid, operations);
        this.outputHandler.handleOutput(((ElectrolysisRecipe)this.recipe).getOutput(this.recipeFluid), operations);
    }
}

