/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraftforge.fluids.FluidStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class RotaryCachedRecipe
extends CachedRecipe<RotaryRecipe> {
    private final IOutputHandler<@NonNull GasStack> gasOutputHandler;
    private final IOutputHandler<@NonNull FluidStack> fluidOutputHandler;
    private final IInputHandler<@NonNull FluidStack> fluidInputHandler;
    private final IInputHandler<@NonNull GasStack> gasInputHandler;
    private final BooleanSupplier modeSupplier;
    private FluidStack recipeFluid = FluidStack.EMPTY;
    private GasStack recipeGas = GasStack.EMPTY;

    public RotaryCachedRecipe(RotaryRecipe recipe, IInputHandler<@NonNull FluidStack> fluidInputHandler, IInputHandler<@NonNull GasStack> gasInputHandler, IOutputHandler<@NonNull GasStack> gasOutputHandler, IOutputHandler<@NonNull FluidStack> fluidOutputHandler, BooleanSupplier modeSupplier) {
        super(recipe);
        this.fluidInputHandler = Objects.requireNonNull(fluidInputHandler, "Fluid input handler cannot be null.");
        this.gasInputHandler = Objects.requireNonNull(gasInputHandler, "Gas input handler cannot be null.");
        this.gasOutputHandler = Objects.requireNonNull(gasOutputHandler, "Gas output handler cannot be null.");
        this.fluidOutputHandler = Objects.requireNonNull(fluidOutputHandler, "Fluid output handler cannot be null.");
        this.modeSupplier = Objects.requireNonNull(modeSupplier, "Mode supplier cannot be null.");
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        if (this.modeSupplier.getAsBoolean()) {
            if (!((RotaryRecipe)this.recipe).hasFluidToGas()) {
                return -1;
            }
            this.recipeFluid = this.fluidInputHandler.getRecipeInput(((RotaryRecipe)this.recipe).getFluidInput());
            if (this.recipeFluid.isEmpty()) {
                return -1;
            }
            if ((currentMax = this.fluidInputHandler.operationsCanSupport(this.recipeFluid, currentMax)) <= 0) {
                return -1;
            }
            return this.gasOutputHandler.operationsRoomFor(((RotaryRecipe)this.recipe).getGasOutput(this.recipeFluid), currentMax);
        }
        if (!((RotaryRecipe)this.recipe).hasGasToFluid()) {
            return -1;
        }
        this.recipeGas = this.gasInputHandler.getRecipeInput(((RotaryRecipe)this.recipe).getGasInput());
        if (this.recipeGas.isEmpty()) {
            return -1;
        }
        if ((currentMax = this.gasInputHandler.operationsCanSupport(this.recipeGas, currentMax)) <= 0) {
            return -1;
        }
        return this.fluidOutputHandler.operationsRoomFor(((RotaryRecipe)this.recipe).getFluidOutput(this.recipeGas), currentMax);
    }

    @Override
    public boolean isInputValid() {
        if (this.modeSupplier.getAsBoolean()) {
            if (!((RotaryRecipe)this.recipe).hasFluidToGas()) {
                return false;
            }
            FluidStack fluidStack = this.fluidInputHandler.getInput();
            if (fluidStack.isEmpty()) {
                return false;
            }
            return ((RotaryRecipe)this.recipe).test(fluidStack);
        }
        if (!((RotaryRecipe)this.recipe).hasGasToFluid()) {
            return false;
        }
        GasStack gasStack = this.gasInputHandler.getInput();
        if (gasStack.isEmpty()) {
            return false;
        }
        return ((RotaryRecipe)this.recipe).test(gasStack);
    }

    @Override
    protected void finishProcessing(int operations) {
        if (this.modeSupplier.getAsBoolean()) {
            if (((RotaryRecipe)this.recipe).hasFluidToGas()) {
                if (this.recipeFluid.isEmpty()) {
                    return;
                }
                this.fluidInputHandler.use(this.recipeFluid, operations);
                this.gasOutputHandler.handleOutput(((RotaryRecipe)this.recipe).getGasOutput(this.recipeFluid), operations);
            }
        } else if (((RotaryRecipe)this.recipe).hasGasToFluid()) {
            if (this.recipeGas.isEmpty()) {
                return;
            }
            this.gasInputHandler.use(this.recipeGas, operations);
            this.fluidOutputHandler.handleOutput(((RotaryRecipe)this.recipe).getFluidOutput(this.recipeGas), operations);
        }
    }
}

