/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache.chemical;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.chemical.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemStackChemicalToItemStackCachedRecipe<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ItemStackChemicalToItemStackRecipe<CHEMICAL, STACK, INGREDIENT>>
extends CachedRecipe<RECIPE> {
    private final IOutputHandler<@NonNull ItemStack> outputHandler;
    private final IInputHandler<@NonNull STACK> chemicalInputHandler;
    private final IInputHandler<@NonNull ItemStack> itemInputHandler;
    private ItemStack recipeItem = ItemStack.field_190927_a;
    @Nullable
    private STACK recipeChemical;

    public ItemStackChemicalToItemStackCachedRecipe(RECIPE recipe, IInputHandler<@NonNull ItemStack> itemInputHandler, IInputHandler<@NonNull STACK> chemicalInputHandler, IOutputHandler<@NonNull ItemStack> outputHandler) {
        super(recipe);
        this.itemInputHandler = Objects.requireNonNull(itemInputHandler, "Item input handler cannot be null.");
        this.chemicalInputHandler = Objects.requireNonNull(chemicalInputHandler, "Chemical input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        this.recipeItem = this.itemInputHandler.getRecipeInput(((ItemStackChemicalToItemStackRecipe)this.recipe).getItemInput());
        if (this.recipeItem.func_190926_b()) {
            return -1;
        }
        this.recipeChemical = (ChemicalStack)this.chemicalInputHandler.getRecipeInput((InputIngredient<STACK>)((ItemStackChemicalToItemStackRecipe)this.recipe).getChemicalInput());
        if (((ChemicalStack)this.recipeChemical).isEmpty()) {
            return -1;
        }
        currentMax = this.itemInputHandler.operationsCanSupport(this.recipeItem, currentMax);
        if ((currentMax = this.chemicalInputHandler.operationsCanSupport(this.recipeChemical, currentMax)) <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((ItemStackChemicalToItemStackRecipe)this.recipe).getOutput(this.recipeItem, this.recipeChemical), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((ItemStackChemicalToItemStackRecipe)this.recipe).test(this.itemInputHandler.getInput(), (ChemicalStack)this.chemicalInputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        if (this.recipeItem.func_190926_b() || this.recipeChemical == null || ((ChemicalStack)this.recipeChemical).isEmpty()) {
            return;
        }
        this.itemInputHandler.use(this.recipeItem, operations);
        this.chemicalInputHandler.use(this.recipeChemical, operations);
        this.outputHandler.handleOutput(((ItemStackChemicalToItemStackRecipe)this.recipe).getOutput(this.recipeItem, this.recipeChemical), operations);
    }
}

