/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.chemical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Contract;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ItemStackToChemicalRecipe<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
extends MekanismRecipe
implements Predicate<ItemStack> {
    protected final ItemStackIngredient input;
    protected final STACK output;

    public ItemStackToChemicalRecipe(ResourceLocation id, ItemStackIngredient input, STACK output) {
        super(id);
        this.input = Objects.requireNonNull(input, "Input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (((ChemicalStack)output).isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = ((ChemicalStack)output).copy();
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return this.input.test(itemStack);
    }

    public ItemStackIngredient getInput() {
        return this.input;
    }

    @Contract(value="_ -> new", pure=true)
    public STACK getOutput(ItemStack input) {
        return (STACK)((ChemicalStack)this.output).copy();
    }

    @Deprecated
    public STACK getOutputDefinition() {
        return this.output;
    }

    public List<STACK> getOutputDefinitionNew() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.input.write(buffer);
        ((ChemicalStack)this.output).writeToPacket(buffer);
    }
}

