/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.inputs;

import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import mekanism.api.recipes.inputs.chemical.InfusionStackIngredient;
import mekanism.api.recipes.inputs.chemical.PigmentStackIngredient;
import mekanism.api.recipes.inputs.chemical.SlurryStackIngredient;

@ParametersAreNonnullByDefault
public class BoxedChemicalInputHandler {
    private final MergedChemicalTank chemicalTank;

    public BoxedChemicalInputHandler(MergedChemicalTank chemicalTank) {
        this.chemicalTank = Objects.requireNonNull(chemicalTank);
    }

    public BoxedChemicalStack getInput() {
        MergedChemicalTank.Current current = this.chemicalTank.getCurrent();
        if (current == MergedChemicalTank.Current.EMPTY) {
            return BoxedChemicalStack.EMPTY;
        }
        return BoxedChemicalStack.box(this.chemicalTank.getTankFromCurrent(current).getStack());
    }

    public BoxedChemicalStack getRecipeInput(IChemicalStackIngredient<?, ?> recipeIngredient) {
        BoxedChemicalStack input = this.getInput();
        if (input.isEmpty()) {
            return BoxedChemicalStack.EMPTY;
        }
        if (recipeIngredient instanceof GasStackIngredient) {
            if (input.getChemicalType() == ChemicalType.GAS) {
                return BoxedChemicalStack.box(((GasStackIngredient)recipeIngredient).getMatchingInstance((GasStack)input.getChemicalStack()));
            }
        } else if (recipeIngredient instanceof InfusionStackIngredient) {
            if (input.getChemicalType() == ChemicalType.INFUSION) {
                return BoxedChemicalStack.box(((InfusionStackIngredient)recipeIngredient).getMatchingInstance((InfusionStack)input.getChemicalStack()));
            }
        } else if (recipeIngredient instanceof PigmentStackIngredient) {
            if (input.getChemicalType() == ChemicalType.PIGMENT) {
                return BoxedChemicalStack.box(((PigmentStackIngredient)recipeIngredient).getMatchingInstance((PigmentStack)input.getChemicalStack()));
            }
        } else if (recipeIngredient instanceof SlurryStackIngredient) {
            if (input.getChemicalType() == ChemicalType.SLURRY) {
                return BoxedChemicalStack.box(((SlurryStackIngredient)recipeIngredient).getMatchingInstance((SlurryStack)input.getChemicalStack()));
            }
        } else {
            throw new IllegalStateException("Unknown Chemical Type");
        }
        return BoxedChemicalStack.EMPTY;
    }

    public void use(BoxedChemicalStack recipeInput, long operations) {
        if (operations == 0L || recipeInput.isEmpty()) {
            return;
        }
        BoxedChemicalStack inputGas = this.getInput();
        if (!inputGas.isEmpty()) {
            long amount = recipeInput.getChemicalStack().getAmount() * operations;
            BoxedChemicalInputHandler.logMismatchedStackSize(this.chemicalTank.getTankForType(inputGas.getChemicalType()).shrinkStack(amount, Action.EXECUTE), amount);
        }
    }

    @Deprecated
    public int operationsCanSupport(IChemicalStackIngredient<?, ?> recipeIngredient, int currentMax) {
        return this.operationsCanSupport(recipeIngredient, currentMax, 1L);
    }

    @Deprecated
    public int operationsCanSupport(IChemicalStackIngredient<?, ?> recipeIngredient, int currentMax, long usageMultiplier) {
        return this.operationsCanSupport(this.getRecipeInput(recipeIngredient), currentMax, usageMultiplier);
    }

    public int operationsCanSupport(BoxedChemicalStack recipeInput, int currentMax) {
        return this.operationsCanSupport(recipeInput, currentMax, 1L);
    }

    public int operationsCanSupport(BoxedChemicalStack recipeInput, int currentMax, long usageMultiplier) {
        if (currentMax <= 0 || usageMultiplier == 0L) {
            return currentMax;
        }
        if (recipeInput.isEmpty()) {
            return 0;
        }
        return Math.min(MathUtils.clampToInt(this.getInput().getChemicalStack().getAmount() / (recipeInput.getChemicalStack().getAmount() * usageMultiplier)), currentMax);
    }

    private static void logMismatchedStackSize(long actual, long expected) {
        if (expected != actual) {
            MekanismAPI.logger.error("Stack size changed by a different amount ({}) than requested ({}).", (Object)actual, (Object)expected, (Object)new Exception());
        }
    }
}

