/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.text;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IIncrementalEnum;
import mekanism.api.math.MathUtils;
import mekanism.api.text.APILang;
import mekanism.api.text.TextComponentUtil;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.Tags;

public enum EnumColor implements IIncrementalEnum<EnumColor>
{
    BLACK("\u00a70", APILang.COLOR_BLACK, "Black", "black", new int[]{64, 64, 64}, DyeColor.BLACK),
    DARK_BLUE("\u00a71", APILang.COLOR_DARK_BLUE, "Blue", "blue", new int[]{54, 107, 208}, DyeColor.BLUE),
    DARK_GREEN("\u00a72", APILang.COLOR_DARK_GREEN, "Green", "green", new int[]{89, 193, 95}, DyeColor.GREEN),
    DARK_AQUA("\u00a73", APILang.COLOR_DARK_AQUA, "Cyan", "cyan", new int[]{0, 243, 208}, DyeColor.CYAN),
    DARK_RED("\u00a74", APILang.COLOR_DARK_RED, "Dark Red", "dark_red", new int[]{201, 7, 31}, MaterialColor.field_151655_K, (ITag<Item>)Tags.Items.DYES_RED, null),
    PURPLE("\u00a75", APILang.COLOR_PURPLE, "Purple", "purple", new int[]{164, 96, 217}, DyeColor.PURPLE),
    ORANGE("\u00a76", APILang.COLOR_ORANGE, "Orange", "orange", new int[]{255, 161, 96}, DyeColor.ORANGE),
    GRAY("\u00a77", APILang.COLOR_GRAY, "Light Gray", "light_gray", new int[]{207, 207, 207}, DyeColor.LIGHT_GRAY),
    DARK_GRAY("\u00a78", APILang.COLOR_DARK_GRAY, "Gray", "gray", new int[]{122, 122, 122}, DyeColor.GRAY),
    INDIGO("\u00a79", APILang.COLOR_INDIGO, "Light Blue", "light_blue", new int[]{85, 158, 255}, DyeColor.LIGHT_BLUE),
    BRIGHT_GREEN("\u00a7a", APILang.COLOR_BRIGHT_GREEN, "Lime", "lime", new int[]{117, 255, 137}, DyeColor.LIME),
    AQUA("\u00a7b", APILang.COLOR_AQUA, "Aqua", "aqua", new int[]{48, 255, 249}, MaterialColor.field_151674_s, (ITag<Item>)Tags.Items.DYES_LIGHT_BLUE, null),
    RED("\u00a7c", APILang.COLOR_RED, "Red", "red", new int[]{255, 56, 60}, DyeColor.RED),
    PINK("\u00a7d", APILang.COLOR_PINK, "Magenta", "magenta", new int[]{213, 94, 203}, DyeColor.MAGENTA),
    YELLOW("\u00a7e", APILang.COLOR_YELLOW, "Yellow", "yellow", new int[]{255, 221, 79}, DyeColor.YELLOW),
    WHITE("\u00a7f", APILang.COLOR_WHITE, "White", "white", new int[]{255, 255, 255}, DyeColor.WHITE),
    BROWN("\u00a76", APILang.COLOR_BROWN, "Brown", "brown", new int[]{161, 118, 73}, DyeColor.BROWN),
    BRIGHT_PINK("\u00a7d", APILang.COLOR_BRIGHT_PINK, "Pink", "pink", new int[]{255, 188, 196}, DyeColor.PINK);

    private static final EnumColor[] COLORS;
    public final String code;
    private int[] rgbCode;
    private Color color;
    private final APILang langEntry;
    private final String englishName;
    private final String registryPrefix;
    @Nullable
    private final DyeColor dyeColor;
    private final MaterialColor mapColor;
    private final ITag<Item> dyeTag;

    private EnumColor(String s, APILang langEntry, String englishName, String registryPrefix, int[] rgbCode, DyeColor dyeColor) {
        this(s, langEntry, englishName, registryPrefix, rgbCode, dyeColor.func_196055_e(), (ITag<Item>)dyeColor.getTag(), dyeColor);
    }

    private EnumColor(String code, APILang langEntry, String englishName, String registryPrefix, int[] rgbCode, @Nullable MaterialColor mapColor, ITag<Item> dyeTag, DyeColor dyeColor) {
        this.code = code;
        this.langEntry = langEntry;
        this.englishName = englishName;
        this.dyeColor = dyeColor;
        this.registryPrefix = registryPrefix;
        this.setColorFromAtlas(rgbCode);
        this.mapColor = mapColor;
        this.dyeTag = dyeTag;
    }

    public String getRegistryPrefix() {
        return this.registryPrefix;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public MaterialColor getMapColor() {
        return this.mapColor;
    }

    @Deprecated
    public ITag<Item> getDyeTag() {
        return this.dyeTag;
    }

    @Deprecated
    public boolean hasDyeName() {
        return this.dyeColor != null;
    }

    @Nullable
    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    public ITextComponent getColoredName() {
        return TextComponentUtil.build(this, this.getName());
    }

    public IFormattableTextComponent getName() {
        return this.langEntry.translate(new Object[0]);
    }

    public APILang getLangEntry() {
        return this.langEntry;
    }

    public float getColor(int index) {
        return (float)this.rgbCode[index] / 255.0f;
    }

    public Color getColor() {
        return this.color;
    }

    public String toString() {
        return this.code;
    }

    public static EnumColor byIndexStatic(int index) {
        return MathUtils.getByIndexMod(COLORS, index);
    }

    @Override
    @Nonnull
    public EnumColor byIndex(int index) {
        return EnumColor.byIndexStatic(index);
    }

    public void setColorFromAtlas(int[] color) {
        this.rgbCode = color;
        this.color = Color.func_240743_a_((int)(this.rgbCode[0] << 16 | this.rgbCode[1] << 8 | this.rgbCode[2]));
    }

    public int[] getRgbCode() {
        return this.rgbCode;
    }

    public float[] getRgbCodeFloat() {
        return new float[]{this.getColor(0), this.getColor(1), this.getColor(2)};
    }

    static {
        COLORS = EnumColor.values();
    }
}

