/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.tab.GuiRedstoneControlTab;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.window.GuiUpgradeWindowTab;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.slot.InventoryContainerSlot;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.lib.security.ISecurityObject;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiMekanismTile<TILE extends TileEntityMekanism, CONTAINER extends MekanismTileContainer<TILE>>
extends GuiMekanism<CONTAINER> {
    protected final TILE tile;
    @Nullable
    private GuiUpgradeWindowTab upgradeWindowTab;

    protected GuiMekanismTile(CONTAINER container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.tile = ((MekanismTileContainer)container).getTileEntity();
    }

    public TILE getTileEntity() {
        return this.tile;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addGenericTabs();
    }

    protected void addGenericTabs() {
        if (((TileEntityMekanism)this.tile).supportsUpgrades()) {
            this.upgradeWindowTab = (GuiUpgradeWindowTab)this.func_230480_a_(new GuiUpgradeWindowTab(this, (TileEntityMekanism)this.tile, () -> this.upgradeWindowTab));
        }
        if (((TileEntityMekanism)this.tile).supportsRedstone()) {
            this.func_230480_a_(new GuiRedstoneControlTab(this, (TileEntityMekanism)this.tile));
        }
        if (((TileEntityMekanism)this.tile).hasSecurity()) {
            this.addSecurityTab();
        }
    }

    protected void addSecurityTab() {
        this.func_230480_a_(new GuiSecurityTab((IGuiWrapper)this, (ISecurityObject)this.tile));
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        ItemStack stack;
        super.drawForegroundText(matrix, mouseX, mouseY);
        if (this.tile instanceof ISideConfiguration && !(stack = this.getMinecraft().field_71439_g.field_71071_by.func_70445_o()).func_190926_b() && stack.func_77973_b() instanceof ItemConfigurator) {
            for (int i = 0; i < ((MekanismTileContainer)this.field_147002_h).field_75151_b.size(); ++i) {
                Slot slot = (Slot)((MekanismTileContainer)this.field_147002_h).field_75151_b.get(i);
                if (!this.isMouseOverSlot(slot, mouseX, mouseY)) continue;
                DataType data = this.getFromSlot(slot);
                if (data == null) break;
                EnumColor color = data.getColor();
                this.displayTooltip(matrix, (ITextComponent)MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(color, data, color.getName()), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
                break;
            }
        }
    }

    public void renderTitleText(MatrixStack matrix) {
        this.drawTitleText(matrix, ((TileEntityMekanism)this.tile).getName(), this.field_238743_q_);
    }

    private DataType getFromSlot(Slot slot) {
        ISideConfiguration config;
        ConfigInfo info;
        if (slot.field_75222_d < this.tile.getSlots() && slot instanceof InventoryContainerSlot && (info = (config = (ISideConfiguration)this.tile).getConfig().getConfig(TransmissionType.ITEM)) != null) {
            Set<DataType> supportedDataTypes = info.getSupportedDataTypes();
            IInventorySlot inventorySlot = ((InventoryContainerSlot)slot).getInventorySlot();
            for (DataType type : supportedDataTypes) {
                ISlotInfo slotInfo = info.getSlotInfo(type);
                if (!(slotInfo instanceof InventorySlotInfo) || !((InventorySlotInfo)slotInfo).hasSlot(inventorySlot)) continue;
                return type;
            }
        }
        return null;
    }
}

