/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.window.GuiColorWindow;
import mekanism.common.MekanismLang;
import mekanism.common.lib.Color;
import mekanism.common.util.text.TextUtils;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public class GuiColorPickerSlot
extends GuiElement {
    private final Supplier<Color> supplier;
    private final Consumer<Color> consumer;

    public GuiColorPickerSlot(IGuiWrapper gui, int x, int y, Supplier<Color> supplier, Consumer<Color> consumer) {
        super(gui, x, y, 18, 18);
        this.supplier = supplier;
        this.consumer = consumer;
        this.addChild(new GuiElementHolder(gui, this.relativeX, this.relativeY, 18, 18));
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        super.func_230443_a_(matrix, mouseX, mouseY);
        IFormattableTextComponent hex = MekanismLang.GENERIC_HEX.translateColored(EnumColor.GRAY, TextUtils.hex(false, 3, this.supplier.get().rgb()));
        this.displayTooltip(matrix, (ITextComponent)hex, mouseX, mouseY);
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        GuiUtils.fill(matrix, this.relativeX + 1, this.relativeY + 1, this.getButtonWidth() - 2, this.getButtonHeight() - 2, this.supplier.get().argb());
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        GuiColorWindow window = new GuiColorWindow(this.gui(), this.getGuiWidth() / 2 - 80, this.getGuiHeight() / 2 - 60, this.consumer);
        window.setColor(this.supplier.get());
        this.gui().addWindow(window);
    }
}

