/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.bar;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.warning.WarningTracker;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiBar<INFO extends IBarInfoHandler>
extends GuiTexturedElement {
    public static final ResourceLocation BAR = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BAR, "base.png");
    private final INFO handler;
    protected final boolean horizontal;
    @Nullable
    private BooleanSupplier warningSupplier;

    public GuiBar(ResourceLocation resource, IGuiWrapper gui, INFO handler, int x, int y, int width, int height, boolean horizontal) {
        super(resource, gui, x, y, width + 2, height + 2);
        this.handler = handler;
        this.horizontal = horizontal;
    }

    public GuiBar<INFO> warning(@Nonnull WarningTracker.WarningType type, @Nonnull BooleanSupplier warningSupplier) {
        this.warningSupplier = this.gui().trackWarning(type, warningSupplier);
        return this;
    }

    public INFO getHandler() {
        return this.handler;
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        boolean warning;
        this.renderExtendedTexture(matrix, BAR, 2, 2);
        boolean bl = warning = this.warningSupplier != null && this.warningSupplier.getAsBoolean();
        if (warning) {
            GuiBar.minecraft.field_71446_o.func_110577_a(GuiSlot.WARNING_BACKGROUND_TEXTURE);
            GuiBar.func_238463_a_((MatrixStack)matrix, (int)(this.field_230690_l_ + 1), (int)(this.field_230691_m_ + 1), (float)0.0f, (float)0.0f, (int)(this.field_230688_j_ - 2), (int)(this.field_230689_k_ - 2), (int)256, (int)256);
        }
        this.drawContentsChecked(matrix, mouseX, mouseY, partialTicks, this.handler.getLevel(), warning);
    }

    void drawContentsChecked(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks, double handlerLevel, boolean warning) {
        if (handlerLevel > 0.0) {
            GuiBar.minecraft.field_71446_o.func_110577_a(this.getResource());
            this.renderBarOverlay(matrix, mouseX, mouseY, partialTicks, handlerLevel);
            if (warning && handlerLevel == 1.0) {
                GuiBar.minecraft.field_71446_o.func_110577_a(WARNING_TEXTURE);
                if (this.horizontal) {
                    int halfHeight = (this.field_230689_k_ - 2) / 2;
                    GuiBar.func_238463_a_((MatrixStack)matrix, (int)(this.field_230690_l_ + 1), (int)(this.field_230691_m_ + 1 + halfHeight), (float)0.0f, (float)halfHeight, (int)(this.field_230688_j_ - 2), (int)halfHeight, (int)256, (int)256);
                } else {
                    int halfWidth = (this.field_230688_j_ - 2) / 2;
                    GuiBar.func_238463_a_((MatrixStack)matrix, (int)(this.field_230690_l_ + 1 + halfWidth), (int)(this.field_230691_m_ + 1), (float)halfWidth, (float)0.0f, (int)halfWidth, (int)(this.field_230689_k_ - 2), (int)256, (int)256);
                }
            }
        }
    }

    protected abstract void renderBarOverlay(MatrixStack var1, int var2, int var3, float var4, double var5);

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        super.func_230443_a_(matrix, mouseX, mouseY);
        ITextComponent tooltip = this.handler.getTooltip();
        if (tooltip != null) {
            this.displayTooltip(matrix, tooltip, mouseX, mouseY);
        }
    }

    protected static int calculateScaled(double scale, int value) {
        if (scale == 1.0) {
            return value;
        }
        if (scale < 1.0) {
            return (int)(scale * (double)value);
        }
        return (int)Math.round(scale * (double)value);
    }

    public static interface IBarInfoHandler {
        @Nullable
        default public ITextComponent getTooltip() {
            return null;
        }

        public double getLevel();
    }
}

