/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.slot.GuiSequencedSlotDisplay;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.warning.WarningTracker;
import mekanism.common.MekanismLang;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.oredictionificator.OredictionificatorFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.lib.collection.HashList;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.util.NonNullSupplier;

public class FilterButton
extends MekanismButton {
    private static final ResourceLocation TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "filter_holder.png");
    protected static final int TEXTURE_WIDTH = 96;
    protected static final int TEXTURE_HEIGHT = 58;
    protected final Supplier<HashList<? extends IFilter<?>>> filters;
    protected final GuiSequencedSlotDisplay slotDisplay;
    protected final IntSupplier filterIndex;
    private final GuiSlot slot;
    protected final int index;
    private IFilter<?> prevFilter;

    @Nullable
    protected static IFilter<?> getFilter(Supplier<HashList<? extends IFilter<?>>> filters, IntSupplier filterIndex, int index) {
        return filters.get().getOrNull(filterIndex.getAsInt() + index);
    }

    public FilterButton(IGuiWrapper gui, int x, int y, int width, int height, int index, IntSupplier filterIndex, Supplier<HashList<? extends IFilter<?>>> filters, ObjIntConsumer<IFilter<?>> onPress, Function<IFilter<?>, List<ItemStack>> renderStackSupplier) {
        super(gui, x, y, width, height, StringTextComponent.field_240750_d_, () -> onPress.accept(FilterButton.getFilter(filters, filterIndex, index), filterIndex.getAsInt() + index), null);
        this.index = index;
        this.filterIndex = filterIndex;
        this.filters = filters;
        this.slot = this.addChild(new GuiSlot(SlotType.NORMAL, gui, this.relativeX + 2, this.relativeY + 2));
        this.slotDisplay = this.addChild(new GuiSequencedSlotDisplay(gui, this.relativeX + 3, this.relativeY + 3, (NonNullSupplier<List<ItemStack>>)((NonNullSupplier)() -> (List)renderStackSupplier.apply(FilterButton.getFilter(filters, filterIndex, index)))));
        this.setButtonBackground(GuiElement.ButtonBackground.NONE);
    }

    public FilterButton warning(@Nonnull WarningTracker.WarningType type, @Nonnull Predicate<IFilter<?>> hasWarning) {
        this.slot.warning(type, () -> hasWarning.test(FilterButton.getFilter(this.filters, this.filterIndex, this.index)));
        return this;
    }

    protected void setVisibility(boolean visible) {
        this.field_230694_p_ = visible;
    }

    public void func_230430_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.setVisibility(FilterButton.getFilter(this.filters, this.filterIndex, this.index) != null);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        FilterButton.minecraft.field_71446_o.func_110577_a(TEXTURE);
        FilterButton.func_238466_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)this.field_230688_j_, (int)this.field_230689_k_, (float)0.0f, (float)(this.isMouseOverCheckWindows(mouseX, mouseY) ? 0.0f : 29.0f), (int)96, (int)29, (int)96, (int)58);
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        IFilter<?> filter = FilterButton.getFilter(this.filters, this.filterIndex, this.index);
        if (filter != this.prevFilter) {
            this.slotDisplay.updateStackList();
            this.prevFilter = filter;
        }
        int x = this.field_230690_l_ - this.getGuiLeft();
        int y = this.field_230691_m_ - this.getGuiTop();
        if (filter instanceof IItemStackFilter) {
            this.drawFilterType(matrix, x, y, MekanismLang.ITEM_FILTER);
        } else if (filter instanceof ITagFilter) {
            this.drawFilterType(matrix, x, y, MekanismLang.TAG_FILTER);
        } else if (filter instanceof IMaterialFilter) {
            this.drawFilterType(matrix, x, y, MekanismLang.MATERIAL_FILTER);
        } else if (filter instanceof IModIDFilter) {
            this.drawFilterType(matrix, x, y, MekanismLang.MODID_FILTER);
        } else if (filter instanceof OredictionificatorFilter) {
            this.drawFilterType(matrix, x, y, MekanismLang.FILTER);
            this.drawTextScaledBound(matrix, ((OredictionificatorFilter)filter).getFilterText(), x + 22, y + 11, this.titleTextColor(), this.getMaxLength());
        }
        if (filter instanceof SorterFilter) {
            SorterFilter sorterFilter = (SorterFilter)filter;
            this.drawTextScaledBound(matrix, (ITextComponent)(sorterFilter.color == null ? MekanismLang.NONE.translate(new Object[0]) : sorterFilter.color.getColoredName()), x + 22, y + 11, this.titleTextColor(), this.getMaxLength());
        }
    }

    protected int getMaxLength() {
        return this.field_230688_j_ - 22 - 2;
    }

    private void drawFilterType(MatrixStack matrix, int x, int y, ILangEntry langEntry) {
        this.drawTextScaledBound(matrix, (ITextComponent)langEntry.translate(new Object[0]), x + 22, y + 2, this.titleTextColor(), this.getMaxLength());
    }
}

