/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.FilterButton;
import mekanism.client.gui.element.button.FilterSelectButton;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.lib.collection.HashList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class MovableFilterButton
extends FilterButton {
    private final FilterSelectButton upButton;
    private final FilterSelectButton downButton;

    public MovableFilterButton(IGuiWrapper gui, int x, int y, int index, IntSupplier filterIndex, Supplier<HashList<? extends IFilter<?>>> filters, IntConsumer upButtonPress, IntConsumer downButtonPress, ObjIntConsumer<IFilter<?>> onPress, Function<IFilter<?>, List<ItemStack>> renderStackSupplier) {
        this(gui, x, y, 96, 29, index, filterIndex, filters, upButtonPress, downButtonPress, onPress, renderStackSupplier);
    }

    public MovableFilterButton(IGuiWrapper gui, int x, int y, int width, int height, int index, IntSupplier filterIndex, Supplier<HashList<? extends IFilter<?>>> filters, IntConsumer upButtonPress, IntConsumer downButtonPress, ObjIntConsumer<IFilter<?>> onPress, Function<IFilter<?>, List<ItemStack>> renderStackSupplier) {
        super(gui, x, y, width, height, index, filterIndex, filters, onPress, renderStackSupplier);
        int arrowX = this.relativeX + width - 12;
        this.upButton = this.addPositionOnlyChild(new FilterSelectButton(gui, arrowX, this.relativeY + 1, false, () -> upButtonPress.accept(index + filterIndex.getAsInt()), (onHover, matrix, xAxis, yAxis) -> this.displayTooltip(matrix, (ITextComponent)MekanismLang.MOVE_UP.translate(new Object[0]), xAxis, yAxis)));
        this.downButton = this.addPositionOnlyChild(new FilterSelectButton(gui, arrowX, this.relativeY + height - 8, true, () -> downButtonPress.accept(index + filterIndex.getAsInt()), (onHover, matrix, xAxis, yAxis) -> this.displayTooltip(matrix, (ITextComponent)MekanismLang.MOVE_DOWN.translate(new Object[0]), xAxis, yAxis)));
    }

    @Override
    public void func_230982_a_(double mouseX, double mouseY) {
        if (this.upButton.func_231047_b_(mouseX, mouseY)) {
            this.upButton.func_230982_a_(mouseX, mouseY);
        } else if (this.downButton.func_231047_b_(mouseX, mouseY)) {
            this.downButton.func_230982_a_(mouseX, mouseY);
        } else {
            super.func_230982_a_(mouseX, mouseY);
        }
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        int xAxis = mouseX - this.getGuiLeft();
        int yAxis = mouseY - this.getGuiTop();
        if (this.upButton.isMouseOverCheckWindows(mouseX, mouseY)) {
            this.upButton.func_230443_a_(matrix, xAxis, yAxis);
        } else if (this.downButton.isMouseOverCheckWindows(mouseX, mouseY)) {
            this.downButton.func_230443_a_(matrix, xAxis, yAxis);
        }
        super.renderForeground(matrix, mouseX, mouseY);
    }

    @Override
    protected void setVisibility(boolean visible) {
        super.setVisibility(visible);
        if (visible) {
            this.updateButtonVisibility();
        } else {
            this.upButton.field_230694_p_ = false;
            this.downButton.field_230694_p_ = false;
        }
    }

    private void updateButtonVisibility() {
        int index = this.filterIndex.getAsInt() + this.index;
        HashList filterList = (HashList)this.filters.get();
        IFilter filter = (IFilter)filterList.getOrNull(index);
        this.upButton.field_230694_p_ = filter != null && index > 0;
        this.downButton.field_230694_p_ = filter != null && index < filterList.size() - 1;
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        IFilter<?> filter = MovableFilterButton.getFilter(this.filters, this.filterIndex, this.index);
        EnumColor color = filter instanceof IItemStackFilter ? EnumColor.INDIGO : (filter instanceof ITagFilter ? EnumColor.BRIGHT_GREEN : (filter instanceof IMaterialFilter ? EnumColor.PINK : (filter instanceof IModIDFilter ? EnumColor.RED : null)));
        if (color != null) {
            GuiUtils.fill(matrix, this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, this.field_230689_k_, MekanismRenderer.getColorARGB(color, 0.5f));
            MekanismRenderer.resetColor();
        }
        this.updateButtonVisibility();
        this.upButton.onDrawBackground(matrix, mouseX, mouseY, partialTicks);
        this.downButton.onDrawBackground(matrix, mouseX, mouseY, partialTicks);
    }

    @Override
    protected int getMaxLength() {
        return super.getMaxLength() - 12;
    }
}

