/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.ModuleBooleanData;
import mekanism.api.gear.config.ModuleConfigData;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.text.IHasTextComponent;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.ModuleConfigItem;
import mekanism.common.network.to_server.PacketUpdateModuleSettings;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiModuleScreen
extends GuiElement {
    private static final ResourceLocation RADIO = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "radio_button.png");
    private static final ResourceLocation SLIDER = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "slider.png");
    private final int TEXT_COLOR = this.screenTextColor();
    private final IntSupplier slotIdSupplier;
    private IModule<?> currentModule;
    private List<MiniElement> miniElements = new ArrayList<MiniElement>();

    public GuiModuleScreen(IGuiWrapper gui, int x, int y, IntSupplier slotIdSupplier) {
        super(gui, x, y, 102, 134);
        this.slotIdSupplier = slotIdSupplier;
    }

    private Runnable getCallback(ModuleConfigData<?> configData, int dataIndex) {
        return () -> {
            if (this.currentModule != null) {
                Mekanism.packetHandler.sendToServer(PacketUpdateModuleSettings.create(this.slotIdSupplier.getAsInt(), this.currentModule.getData(), dataIndex, configData));
            }
        };
    }

    public void setModule(Module<?> module) {
        ArrayList<MiniElement> newElements = new ArrayList<MiniElement>();
        if (module != null) {
            int startY = 3;
            if (module.getData().isExclusive()) {
                startY += 13;
            }
            if (module.getData().getMaxStackSize() > 1) {
                startY += 13;
            }
            List<ModuleConfigItem<?>> configItems = module.getConfigItems();
            int configItemsCount = configItems.size();
            for (int i = 0; i < configItemsCount; ++i) {
                ModuleConfigItem<Enum<? extends IHasTextComponent>> configItem = configItems.get(i);
                if (!(!(configItem.getData() instanceof ModuleBooleanData) || configItem.getName().equals("enabled") && module.getData().isNoDisable())) {
                    if (configItem instanceof ModuleConfigItem.DisableableModuleConfigItem && !((ModuleConfigItem.DisableableModuleConfigItem)configItem).isConfigEnabled()) continue;
                    newElements.add(new BooleanToggle(configItem, 2, startY, i));
                    startY += 24;
                    continue;
                }
                if (!(configItem.getData() instanceof ModuleEnumData)) continue;
                EnumToggle toggle = new EnumToggle(configItem, 2, startY, i);
                newElements.add(toggle);
                startY += 34;
                if (this.currentModule == null || this.currentModule.getData() != module.getData() || !(this.miniElements.get(i) instanceof EnumToggle)) continue;
                toggle.dragging = ((EnumToggle)this.miniElements.get((int)i)).dragging;
            }
        }
        this.currentModule = module;
        this.miniElements = newElements;
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        this.renderBackgroundTexture(matrix, GuiInnerScreen.SCREEN, GuiInnerScreen.SCREEN_SIZE, GuiInnerScreen.SCREEN_SIZE);
        for (MiniElement element : this.miniElements) {
            element.renderBackground(matrix, mouseX, mouseY);
        }
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        super.func_230982_a_(mouseX, mouseY);
        for (MiniElement element : this.miniElements) {
            element.click(mouseX, mouseY);
        }
    }

    @Override
    public void func_231000_a__(double mouseX, double mouseY) {
        super.func_231000_a__(mouseX, mouseY);
        for (MiniElement element : this.miniElements) {
            element.release(mouseX, mouseY);
        }
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        if (this.currentModule != null) {
            int startY = this.relativeY + 5;
            if (this.currentModule.getData().isExclusive()) {
                TranslationTextComponent comp = MekanismLang.MODULE_EXCLUSIVE.translate(new Object[0]);
                this.drawTextWithScale(matrix, (ITextComponent)comp, this.relativeX + 5, startY, 6511572, 0.8f);
                startY += 13;
            }
            if (this.currentModule.getData().getMaxStackSize() > 1) {
                this.drawTextWithScale(matrix, (ITextComponent)MekanismLang.MODULE_INSTALLED.translate(this.currentModule.getInstalledCount()), this.relativeX + 5, startY, this.TEXT_COLOR, 0.8f);
                startY += 13;
            }
        }
        for (MiniElement element : this.miniElements) {
            element.renderForeground(matrix, mouseX, mouseY);
        }
    }

    class EnumToggle
    extends MiniElement {
        final int BAR_LENGTH;
        final int BAR_START = 10;
        final float TEXT_SCALE = 0.7f;
        final ModuleConfigItem<Enum<? extends IHasTextComponent>> data;
        boolean dragging;

        EnumToggle(ModuleConfigItem<Enum<? extends IHasTextComponent>> data, int xPos, int yPos, int dataIndex) {
            super(xPos, yPos, dataIndex);
            this.BAR_LENGTH = GuiModuleScreen.this.func_230998_h_() - 24;
            this.BAR_START = 10;
            this.TEXT_SCALE = 0.7f;
            this.dragging = false;
            this.data = data;
        }

        @Override
        public void renderBackground(MatrixStack matrix, int mouseX, int mouseY) {
            GuiElement.minecraft.field_71446_o.func_110577_a(SLIDER);
            int count = ((ModuleEnumData)this.data.getData()).getEnums().size();
            int center = this.BAR_LENGTH / (count - 1) * this.data.get().ordinal();
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(this.getX() + 10 + center - 2), (int)(this.getY() + 11), (float)0.0f, (float)0.0f, (int)5, (int)6, (int)8, (int)8);
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(this.getX() + 10), (int)(this.getY() + 17), (float)0.0f, (float)6.0f, (int)this.BAR_LENGTH, (int)2, (int)8, (int)8);
        }

        @Override
        public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
            ModuleEnumData enumData = (ModuleEnumData)this.data.getData();
            GuiModuleScreen.this.drawTextWithScale(matrix, this.data.getDescription(), this.getRelativeX() + 3, this.getRelativeY(), GuiModuleScreen.this.TEXT_COLOR, 0.8f);
            List options = enumData.getEnums();
            int count = options.size();
            for (int i = 0; i < count; ++i) {
                int diffFromCenter = this.BAR_LENGTH / (count - 1) * i - this.BAR_LENGTH / 2;
                float diffScale = 0.85f;
                int textCenter = this.getRelativeX() + 10 + this.BAR_LENGTH / 2 + (int)((float)diffFromCenter * diffScale);
                GuiModuleScreen.this.drawScaledCenteredText(matrix, ((IHasTextComponent)options.get(i)).getTextComponent(), textCenter, this.getRelativeY() + 20, GuiModuleScreen.this.TEXT_COLOR, 0.7f);
            }
            if (this.dragging) {
                int cur = (int)Math.round((double)(mouseX - this.getX() - 10) / (double)this.BAR_LENGTH * (double)(count - 1));
                if ((cur = Math.min(count - 1, Math.max(0, cur))) != this.data.get().ordinal()) {
                    this.data.set((Enum<? extends IHasTextComponent>)options.get(cur), GuiModuleScreen.this.getCallback(this.data.getData(), this.dataIndex));
                }
            }
        }

        @Override
        public void click(double mouseX, double mouseY) {
            List options = ((ModuleEnumData)this.data.getData()).getEnums();
            if (!this.dragging) {
                int center = this.BAR_LENGTH / (options.size() - 1) * this.data.get().ordinal();
                if (mouseX >= (double)(this.getX() + 10 + center - 2) && mouseX < (double)(this.getX() + 10 + center + 3) && mouseY >= (double)(this.getY() + 11) && mouseY < (double)(this.getY() + 17)) {
                    this.dragging = true;
                }
            }
            if (!this.dragging && mouseX >= (double)(this.getX() + 10) && mouseX < (double)(this.getX() + 10 + this.BAR_LENGTH) && mouseY >= (double)(this.getY() + 10) && mouseY < (double)(this.getY() + 22)) {
                int count = options.size();
                int cur = (int)Math.round((mouseX - (double)this.getX() - 10.0) / (double)this.BAR_LENGTH * (double)(count - 1));
                if ((cur = Math.min(count - 1, Math.max(0, cur))) != this.data.get().ordinal()) {
                    this.data.set((Enum<? extends IHasTextComponent>)options.get(cur), GuiModuleScreen.this.getCallback(this.data.getData(), this.dataIndex));
                }
            }
        }

        @Override
        public void release(double mouseX, double mouseY) {
            this.dragging = false;
        }
    }

    class BooleanToggle
    extends MiniElement {
        final ModuleConfigItem<Boolean> data;

        BooleanToggle(ModuleConfigItem<Boolean> data, int xPos, int yPos, int dataIndex) {
            super(xPos, yPos, dataIndex);
            this.data = data;
        }

        @Override
        public void renderBackground(MatrixStack matrix, int mouseX, int mouseY) {
            boolean hover;
            GuiElement.minecraft.field_71446_o.func_110577_a(RADIO);
            boolean bl = hover = mouseX >= this.getX() + 4 && mouseX < this.getX() + 12 && mouseY >= this.getY() + 11 && mouseY < this.getY() + 19;
            if (this.data.get().booleanValue()) {
                AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(this.getX() + 4), (int)(this.getY() + 11), (float)0.0f, (float)8.0f, (int)8, (int)8, (int)16, (int)16);
            } else {
                AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(this.getX() + 4), (int)(this.getY() + 11), (float)(hover ? 8.0f : 0.0f), (float)0.0f, (int)8, (int)8, (int)16, (int)16);
            }
            boolean bl2 = hover = mouseX >= this.getX() + 50 && mouseX < this.getX() + 58 && mouseY >= this.getY() + 11 && mouseY < this.getY() + 19;
            if (!this.data.get().booleanValue()) {
                AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(this.getX() + 50), (int)(this.getY() + 11), (float)8.0f, (float)8.0f, (int)8, (int)8, (int)16, (int)16);
            } else {
                AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(this.getX() + 50), (int)(this.getY() + 11), (float)(hover ? 8.0f : 0.0f), (float)0.0f, (int)8, (int)8, (int)16, (int)16);
            }
        }

        @Override
        public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
            GuiModuleScreen.this.drawTextWithScale(matrix, this.data.getDescription(), this.getRelativeX() + 3, this.getRelativeY(), GuiModuleScreen.this.TEXT_COLOR, 0.8f);
            GuiModuleScreen.this.drawTextWithScale(matrix, (ITextComponent)MekanismLang.TRUE.translate(new Object[0]), this.getRelativeX() + 16, this.getRelativeY() + 11, GuiModuleScreen.this.TEXT_COLOR, 0.8f);
            GuiModuleScreen.this.drawTextWithScale(matrix, (ITextComponent)MekanismLang.FALSE.translate(new Object[0]), this.getRelativeX() + 62, this.getRelativeY() + 11, GuiModuleScreen.this.TEXT_COLOR, 0.8f);
        }

        @Override
        public void click(double mouseX, double mouseY) {
            if (!this.data.get().booleanValue() && mouseX >= (double)(this.getX() + 4) && mouseX < (double)(this.getX() + 12) && mouseY >= (double)(this.getY() + 11) && mouseY < (double)(this.getY() + 19)) {
                this.data.set(true, GuiModuleScreen.this.getCallback(this.data.getData(), this.dataIndex));
                GuiElement.minecraft.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)((SoundEvent)MekanismSounds.BEEP.get()), (float)1.0f));
            }
            if (this.data.get().booleanValue() && mouseX >= (double)(this.getX() + 50) && mouseX < (double)(this.getX() + 58) && mouseY >= (double)(this.getY() + 11) && mouseY < (double)(this.getY() + 19)) {
                this.data.set(false, GuiModuleScreen.this.getCallback(this.data.getData(), this.dataIndex));
                GuiElement.minecraft.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)((SoundEvent)MekanismSounds.BEEP.get()), (float)1.0f));
            }
        }
    }

    abstract class MiniElement {
        final int xPos;
        final int yPos;
        final int dataIndex;

        public MiniElement(int xPos, int yPos, int dataIndex) {
            this.xPos = xPos;
            this.yPos = yPos;
            this.dataIndex = dataIndex;
        }

        abstract void renderBackground(MatrixStack var1, int var2, int var3);

        abstract void renderForeground(MatrixStack var1, int var2, int var3);

        abstract void click(double var1, double var3);

        void release(double mouseX, double mouseY) {
        }

        int getRelativeX() {
            return GuiModuleScreen.this.relativeX + this.xPos;
        }

        int getRelativeY() {
            return GuiModuleScreen.this.relativeY + this.yPos;
        }

        int getX() {
            return GuiModuleScreen.this.field_230690_l_ + this.xPos;
        }

        int getY() {
            return GuiModuleScreen.this.field_230691_m_ + this.yPos;
        }
    }
}

