/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Upgrade;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.common.MekanismLang;
import mekanism.common.lib.Color;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public class GuiSupportedUpgrades
extends GuiElement {
    private static final int ELEMENT_SIZE = 12;
    private static final int FIRST_ROW_ROOM = 5;
    private static final int ROW_ROOM = 10;
    private final Set<Upgrade> supportedUpgrades;

    public static int calculateNeededRows() {
        int count = EnumUtils.UPGRADES.length;
        if (count <= 5) {
            return 1;
        }
        return 2 + (count -= 5) / 10;
    }

    public GuiSupportedUpgrades(IGuiWrapper gui, int x, int y, Set<Upgrade> supportedUpgrades) {
        super(gui, x, y, 125, 12 * GuiSupportedUpgrades.calculateNeededRows() + 2);
        this.supportedUpgrades = supportedUpgrades;
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        this.renderBackgroundTexture(matrix, GuiElementHolder.HOLDER, 32, 32);
        int backgroundColor = Color.argb(GuiElementHolder.getBackgroundColor()).alpha(0.5).argb();
        for (int i = 0; i < EnumUtils.UPGRADES.length; ++i) {
            Upgrade upgrade = EnumUtils.UPGRADES[i];
            UpgradePos pos = this.getUpgradePos(i);
            int xPos = this.field_230690_l_ + 1 + pos.x;
            int yPos = this.field_230691_m_ + 1 + pos.y;
            this.gui().renderItem(matrix, UpgradeUtils.getStack(upgrade), xPos, yPos, 0.75f);
            if (this.supportedUpgrades.contains(upgrade)) continue;
            RenderSystem.depthFunc((int)516);
            AbstractGui.func_238467_a_((MatrixStack)matrix, (int)xPos, (int)yPos, (int)(xPos + 12), (int)(yPos + 12), (int)backgroundColor);
            RenderSystem.depthFunc((int)515);
        }
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        this.drawTextScaledBound(matrix, (ITextComponent)MekanismLang.UPGRADES_SUPPORTED.translate(new Object[0]), this.relativeX + 2, this.relativeY + 3, this.titleTextColor(), 54.0f);
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        super.func_230443_a_(matrix, mouseX, mouseY);
        for (int i = 0; i < EnumUtils.UPGRADES.length; ++i) {
            UpgradePos pos = this.getUpgradePos(i);
            if (mouseX < this.relativeX + 1 + pos.x || mouseX >= this.relativeX + 1 + pos.x + 12 || mouseY < this.relativeY + 1 + pos.y || mouseY >= this.relativeY + 1 + pos.y + 12) continue;
            Upgrade upgrade = EnumUtils.UPGRADES[i];
            IFormattableTextComponent upgradeName = MekanismLang.UPGRADE_TYPE.translateColored(EnumColor.YELLOW, upgrade);
            List<ITextComponent> tooltip = this.supportedUpgrades.contains(upgrade) ? Arrays.asList(upgradeName, upgrade.getDescription()) : Arrays.asList(MekanismLang.UPGRADE_NOT_SUPPORTED.translateColored(EnumColor.RED, upgradeName), upgrade.getDescription());
            this.displayTooltips(matrix, tooltip, mouseX, mouseY, this.getGuiWidth());
            break;
        }
    }

    private UpgradePos getUpgradePos(int index) {
        int row;
        int n = row = index < 5 ? 0 : 1 + (index - 5) / 10;
        if (row == 0) {
            return new UpgradePos(55 + index % 5 * 12, 0);
        }
        return new UpgradePos((index -= 5) % 10 * 12, row * 12);
    }

    private static class UpgradePos {
        private final int x;
        private final int y;

        public UpgradePos(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

