/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.progress;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.progress.IProgressInfoHandler;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.warning.WarningTracker;
import mekanism.client.jei.interfaces.IJEIRecipeArea;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public class GuiProgress
extends GuiTexturedElement
implements IJEIRecipeArea<GuiProgress> {
    protected final IProgressInfoHandler handler;
    protected final ProgressType type;
    private ResourceLocation[] recipeCategories;
    @Nullable
    private ColorDetails colorDetails;
    @Nullable
    private BooleanSupplier warningSupplier;
    private boolean useFullProgressForWarning;

    public GuiProgress(IProgressInfoHandler.IBooleanProgressInfoHandler handler, ProgressType type, IGuiWrapper gui, int x, int y) {
        this((IProgressInfoHandler)handler, type, gui, x, y);
    }

    public GuiProgress(IProgressInfoHandler handler, ProgressType type, IGuiWrapper gui, int x, int y) {
        super(type.getTexture(), gui, x, y, type.getWidth(), type.getHeight());
        this.type = type;
        this.handler = handler;
    }

    public GuiProgress colored(ColorDetails colorDetails) {
        this.colorDetails = colorDetails;
        return this;
    }

    public GuiProgress warning(@Nonnull WarningTracker.WarningType type, @Nonnull BooleanSupplier warningSupplier) {
        return this.warning(type, warningSupplier, true);
    }

    public GuiProgress warning(@Nonnull WarningTracker.WarningType type, @Nonnull BooleanSupplier warningSupplier, boolean useFullProgressForWarning) {
        this.warningSupplier = this.gui().trackWarning(type, warningSupplier);
        this.useFullProgressForWarning = useFullProgressForWarning;
        return this;
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        if (this.handler.isActive()) {
            double progress;
            GuiProgress.minecraft.field_71446_o.func_110577_a(this.getResource());
            GuiProgress.func_238463_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)0.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.type.getTextureWidth(), (int)this.type.getTextureHeight());
            boolean warning = this.warningSupplier != null && this.warningSupplier.getAsBoolean();
            double d = progress = warning && this.useFullProgressForWarning ? 1.0 : this.getProgress();
            if (this.type.isVertical()) {
                int displayInt = (int)(progress * (double)this.field_230689_k_);
                if (displayInt > 0) {
                    int innerOffsetY = 0;
                    if (this.type.isReverse()) {
                        innerOffsetY += this.type.getTextureHeight() - displayInt;
                    }
                    this.blit(matrix, this.field_230690_l_, this.field_230691_m_ + innerOffsetY, this.type.getOverlayX(warning), this.type.getOverlayY(warning) + innerOffsetY, this.field_230688_j_, displayInt, this.type.getTextureWidth(), this.type.getTextureHeight(), progress, warning);
                }
            } else {
                int innerOffsetX = this.type == ProgressType.BAR ? 1 : 0;
                int displayInt = (int)(progress * (double)(this.field_230688_j_ - 2 * innerOffsetX));
                if (displayInt > 0) {
                    if (this.type.isReverse()) {
                        innerOffsetX += this.type.getTextureWidth() - displayInt;
                    }
                    this.blit(matrix, this.field_230690_l_ + innerOffsetX, this.field_230691_m_, this.type.getOverlayX(warning) + innerOffsetX, this.type.getOverlayY(warning), displayInt, this.field_230689_k_, this.type.getTextureWidth(), this.type.getTextureHeight(), progress, warning);
                }
            }
        }
    }

    protected double getProgress() {
        return Math.min(this.handler.getProgress(), 1.0);
    }

    @Override
    public boolean isActive() {
        return this.handler.isActive();
    }

    @Override
    @Nonnull
    public GuiProgress jeiCategories(ResourceLocation ... recipeCategories) {
        this.recipeCategories = recipeCategories;
        return this;
    }

    @Override
    @Nullable
    public ResourceLocation[] getRecipeCategories() {
        return this.recipeCategories;
    }

    private void blit(MatrixStack matrixStack, int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight, double progress, boolean warning) {
        if (warning || this.colorDetails == null) {
            GuiProgress.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)uOffset, (float)vOffset, (int)width, (int)height, (int)textureWidth, (int)textureHeight);
            return;
        }
        int colorFrom = this.colorDetails.getColorFrom();
        int colorTo = this.colorDetails.getColorTo();
        if (colorFrom == -1 && colorTo == -1) {
            GuiProgress.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)uOffset, (float)vOffset, (int)width, (int)height, (int)textureWidth, (int)textureHeight);
            return;
        }
        int x2 = x + width;
        int y2 = y + height;
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        float minU = uOffset / (float)textureWidth;
        float maxU = (uOffset + (float)width) / (float)textureWidth;
        float minV = vOffset / (float)textureHeight;
        float maxV = (vOffset + (float)height) / (float)textureHeight;
        float alphaFrom = MekanismRenderer.getAlpha(colorFrom);
        float redFrom = MekanismRenderer.getRed(colorFrom);
        float greenFrom = MekanismRenderer.getGreen(colorFrom);
        float blueFrom = MekanismRenderer.getBlue(colorFrom);
        float alphaTo = MekanismRenderer.getAlpha(colorTo);
        float redTo = MekanismRenderer.getRed(colorTo);
        float greenTo = MekanismRenderer.getGreen(colorTo);
        float blueTo = MekanismRenderer.getBlue(colorTo);
        float percent = (float)progress;
        alphaTo = alphaFrom + percent * (alphaTo - alphaFrom);
        redTo = redFrom + percent * (redTo - redFrom);
        greenTo = greenFrom + percent * (greenTo - greenFrom);
        blueTo = blueFrom + percent * (blueTo - blueFrom);
        if (this.type.isReverse()) {
            float alphaTemp = alphaTo;
            float redTemp = redTo;
            float greenTemp = greenTo;
            float blueTemp = blueTo;
            alphaTo = alphaFrom;
            redTo = redFrom;
            greenTo = greenFrom;
            blueTo = blueFrom;
            alphaFrom = alphaTemp;
            redFrom = redTemp;
            greenFrom = greenTemp;
            blueFrom = blueTemp;
        }
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        if (this.type.isVertical()) {
            builder.func_227888_a_(matrix, (float)x, (float)y2, 0.0f).func_227885_a_(redTo, greenTo, blueTo, alphaTo).func_225583_a_(minU, maxV).func_181675_d();
            builder.func_227888_a_(matrix, (float)x2, (float)y2, 0.0f).func_227885_a_(redTo, greenTo, blueTo, alphaTo).func_225583_a_(maxU, maxV).func_181675_d();
            builder.func_227888_a_(matrix, (float)x2, (float)y, 0.0f).func_227885_a_(redFrom, greenFrom, blueFrom, alphaFrom).func_225583_a_(maxU, minV).func_181675_d();
            builder.func_227888_a_(matrix, (float)x, (float)y, 0.0f).func_227885_a_(redFrom, greenFrom, blueFrom, alphaFrom).func_225583_a_(minU, minV).func_181675_d();
        } else {
            builder.func_227888_a_(matrix, (float)x, (float)y2, 0.0f).func_227885_a_(redFrom, greenFrom, blueFrom, alphaFrom).func_225583_a_(minU, maxV).func_181675_d();
            builder.func_227888_a_(matrix, (float)x2, (float)y2, 0.0f).func_227885_a_(redTo, greenTo, blueTo, alphaTo).func_225583_a_(maxU, maxV).func_181675_d();
            builder.func_227888_a_(matrix, (float)x2, (float)y, 0.0f).func_227885_a_(redTo, greenTo, blueTo, alphaTo).func_225583_a_(maxU, minV).func_181675_d();
            builder.func_227888_a_(matrix, (float)x, (float)y, 0.0f).func_227885_a_(redFrom, greenFrom, blueFrom, alphaFrom).func_225583_a_(minU, minV).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        MekanismRenderer.resetColor();
    }

    public static interface ColorDetails {
        public int getColorFrom();

        public int getColorTo();
    }
}

