/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.gear.IModule;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.scroll.GuiScrollList;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public class GuiModuleScrollList
extends GuiScrollList {
    private static final ResourceLocation MODULE_SELECTION = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "module_selection.png");
    private static final int TEXTURE_WIDTH = 100;
    private static final int TEXTURE_HEIGHT = 36;
    private int selectIndex = -1;
    private final Consumer<Module<?>> callback;
    private final List<ModuleData<?>> currentList = new ArrayList();
    private final Supplier<ItemStack> itemSupplier;
    private ItemStack currentItem;

    public GuiModuleScrollList(IGuiWrapper gui, int x, int y, int width, int height, Supplier<ItemStack> itemSupplier, Consumer<Module<?>> callback) {
        super(gui, x, y, width, height, 12, GuiElementHolder.HOLDER, 32);
        this.itemSupplier = itemSupplier;
        this.callback = callback;
        this.updateList(itemSupplier.get(), true);
    }

    public void updateList(ItemStack currentItem, boolean forceReset) {
        ModuleData<?> prevSelect = this.getSelection();
        this.currentItem = currentItem;
        this.currentList.clear();
        this.currentList.addAll(MekanismAPI.getModuleHelper().loadAllTypes(currentItem));
        boolean selected = false;
        if (!forceReset && prevSelect != null) {
            int size = this.currentList.size();
            for (int i = 0; i < size; ++i) {
                if (this.currentList.get(i) != prevSelect) continue;
                this.setSelected(i);
                selected = true;
                break;
            }
        }
        if (!selected) {
            this.clearSelection();
        }
    }

    @Override
    protected int getMaxElements() {
        return this.currentList.size();
    }

    @Override
    public boolean hasSelection() {
        return this.selectIndex != -1;
    }

    @Override
    protected void setSelected(int index) {
        if (index >= 0 && index < this.currentList.size()) {
            this.selectIndex = index;
            this.callback.accept((Module<?>)ModuleHelper.INSTANCE.load(this.currentItem, (IModuleDataProvider)this.currentList.get(index)));
        }
    }

    @Nullable
    public ModuleData<?> getSelection() {
        return this.selectIndex == -1 ? null : this.currentList.get(this.selectIndex);
    }

    @Override
    public void clearSelection() {
        this.selectIndex = -1;
        this.callback.accept(null);
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        ItemStack stack = this.itemSupplier.get();
        if (!ItemStack.func_77989_b((ItemStack)this.currentItem, (ItemStack)stack)) {
            this.updateList(stack, false);
        }
        this.forEachModule((module, multipliedElement) -> {
            IModule instance = MekanismAPI.getModuleHelper().load(this.currentItem, module);
            if (instance != null) {
                int color = module.isExclusive() ? (instance.isEnabled() ? 6511572 : 3025513) : (instance.isEnabled() ? this.titleTextColor() : 6167837);
                this.drawScaledTextScaledBound(matrix, (ITextComponent)TextComponentUtil.build(module), this.relativeX + 13, this.relativeY + 3 + multipliedElement, color, 86.0f, 0.7f);
            }
        });
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        super.func_230443_a_(matrix, mouseX, mouseY);
        if (mouseX >= this.relativeX + 1 && mouseX < this.relativeX + this.barXShift - 1) {
            this.forEachModule((module, multipliedElement) -> {
                IModule instance = MekanismAPI.getModuleHelper().load(this.currentItem, module);
                if (instance != null && mouseY >= this.relativeY + 1 + multipliedElement && mouseY < this.relativeY + 1 + multipliedElement + this.elementHeight) {
                    IFormattableTextComponent t = MekanismLang.GENERIC_FRACTION.translateColored(EnumColor.GRAY, instance.getInstalledCount(), module.getMaxStackSize());
                    this.displayTooltip(matrix, (ITextComponent)MekanismLang.MODULE_INSTALLED.translate(t), mouseX, mouseY, this.getGuiWidth());
                }
            });
        }
    }

    @Override
    public void renderElements(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        GuiModuleScrollList.minecraft.field_71446_o.func_110577_a(MODULE_SELECTION);
        this.forEachModule((module, multipliedElement) -> {
            int shiftedY = this.field_230691_m_ + 1 + multipliedElement;
            int j = 1;
            if (module == this.getSelection()) {
                j = 2;
            } else if (mouseX >= this.field_230690_l_ + 1 && mouseX < this.barX - 1 && mouseY >= shiftedY && mouseY < shiftedY + this.elementHeight) {
                j = 0;
            }
            GuiModuleScrollList.func_238463_a_((MatrixStack)matrix, (int)(this.field_230690_l_ + 1), (int)shiftedY, (float)0.0f, (float)(this.elementHeight * j), (int)100, (int)this.elementHeight, (int)100, (int)36);
            MekanismRenderer.resetColor();
        });
        this.forEachModule((module, multipliedElement) -> this.gui().renderItem(matrix, module.getItemProvider().getItemStack(), this.field_230690_l_ + 3, this.field_230691_m_ + 3 + multipliedElement, 0.5f));
    }

    private void forEachModule(ObjIntConsumer<ModuleData<?>> consumer) {
        int index;
        for (int i = 0; i < this.getFocusedElements() && (index = this.getCurrentSelection() + i) <= this.currentList.size() - 1; ++i) {
            consumer.accept(this.currentList.get(index), this.elementHeight * i);
        }
    }

    @Override
    public void syncFrom(GuiElement element) {
        super.syncFrom(element);
        GuiModuleScrollList old = (GuiModuleScrollList)element;
        this.setSelected(old.selectIndex);
    }
}

