/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.element.GuiDropdown;
import mekanism.client.gui.element.custom.GuiDictionaryTarget;
import mekanism.client.gui.element.scroll.GuiTextScrollList;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.GuiComponents;
import mekanism.common.inventory.container.item.DictionaryContainer;
import mekanism.common.registries.MekanismItems;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class GuiDictionary
extends GuiMekanism<DictionaryContainer> {
    private GuiTextScrollList scrollList;
    private GuiDictionaryTarget target;
    private DictionaryTagType currentType = DictionaryTagType.ITEM;

    public GuiDictionary(DictionaryContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_147000_g += 5;
        this.field_238745_s_ = this.field_147000_g - 96;
        this.field_238743_q_ = 5;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.func_230480_a_(new GuiSlot(SlotType.NORMAL, this, 5, 5).setRenderHover(true));
        this.scrollList = (GuiTextScrollList)this.func_230480_a_(new GuiTextScrollList(this, 7, 29, 162, 42));
        this.func_230480_a_(new GuiDropdown<DictionaryTagType>(this, 124, 73, 45, DictionaryTagType.class, () -> this.currentType, this::setCurrentType));
        this.target = (GuiDictionaryTarget)this.func_230480_a_(new GuiDictionaryTarget(this, 6, 6, this::updateScrollList));
    }

    private void setCurrentType(DictionaryTagType type) {
        this.currentType = type;
        this.scrollList.setText(this.target.getTags(this.currentType));
    }

    private void updateScrollList(Set<DictionaryTagType> supportedTypes) {
        if (!supportedTypes.contains(this.currentType) && !supportedTypes.isEmpty()) {
            this.currentType = supportedTypes.stream().findFirst().orElse(this.currentType);
        }
        this.scrollList.setText(this.target.getTags(this.currentType));
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.drawTitleText(matrix, MekanismItems.DICTIONARY.getTextComponent(), this.field_238743_q_);
        this.drawString(matrix, this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, this.titleTextColor());
        this.drawTextScaledBound(matrix, (ITextComponent)MekanismLang.DICTIONARY_TAG_TYPE.translate(new Object[0]), 77.0f, this.field_238745_s_, this.titleTextColor(), 45.0f);
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 0 && GuiDictionary.func_231173_s_() && !this.target.hasTarget()) {
            for (int i = 0; i < ((DictionaryContainer)this.field_147002_h).field_75151_b.size(); ++i) {
                Slot slot = (Slot)((DictionaryContainer)this.field_147002_h).field_75151_b.get(i);
                if (!this.isMouseOverSlot(slot, mouseX, mouseY)) continue;
                ItemStack stack = slot.func_75211_c();
                if (stack.func_190926_b()) break;
                this.target.setTargetSlot(stack, true);
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public static enum DictionaryTagType implements GuiComponents.IDropdownEnum<DictionaryTagType>
    {
        ITEM(MekanismLang.DICTIONARY_ITEM, MekanismLang.DICTIONARY_ITEM_DESC),
        BLOCK(MekanismLang.DICTIONARY_BLOCK, MekanismLang.DICTIONARY_BLOCK_DESC),
        FLUID(MekanismLang.DICTIONARY_FLUID, MekanismLang.DICTIONARY_FLUID_DESC),
        ENTITY_TYPE(MekanismLang.DICTIONARY_ENTITY_TYPE, MekanismLang.DICTIONARY_ENTITY_TYPE_DESC),
        POTION(MekanismLang.DICTIONARY_POTION, MekanismLang.DICTIONARY_POTION_DESC),
        ENCHANTMENT(MekanismLang.DICTIONARY_ENCHANTMENT, MekanismLang.DICTIONARY_ENCHANTMENT_DESC),
        TILE_ENTITY_TYPE(MekanismLang.DICTIONARY_TILE_ENTITY_TYPE, MekanismLang.DICTIONARY_TILE_ENTITY_TYPE_DESC),
        GAS(MekanismLang.DICTIONARY_GAS, MekanismLang.DICTIONARY_GAS_DESC),
        INFUSE_TYPE(MekanismLang.DICTIONARY_INFUSE_TYPE, MekanismLang.DICTIONARY_INFUSE_TYPE_DESC),
        PIGMENT(MekanismLang.DICTIONARY_PIGMENT, MekanismLang.DICTIONARY_PIGMENT_DESC),
        SLURRY(MekanismLang.DICTIONARY_SLURRY, MekanismLang.DICTIONARY_SLURRY_DESC);

        private final ILangEntry name;
        private final ILangEntry tooltip;

        private DictionaryTagType(ILangEntry name, ILangEntry tooltip) {
            this.name = name;
            this.tooltip = tooltip;
        }

        @Override
        public ITextComponent getTooltip() {
            return this.tooltip.translate(new Object[0]);
        }

        @Override
        public ITextComponent getShortName() {
            return this.name.translate(new Object[0]);
        }
    }
}

