/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiArrowSelection;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.item.SeismicReaderContainer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public class GuiSeismicReader
extends GuiMekanism<SeismicReaderContainer> {
    private final List<BlockState> blockList = new ArrayList<BlockState>();
    private final Object2IntMap<Block> frequencies = new Object2IntOpenHashMap();
    private MekanismButton upButton;
    private MekanismButton downButton;
    private GuiScrollBar scrollBar;

    public GuiSeismicReader(SeismicReaderContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_146999_f = 147;
        this.field_147000_g = 182;
        BlockPos pos = inv.field_70458_d.func_233580_cy_();
        for (BlockPos p : BlockPos.func_218278_a((BlockPos)new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p()), (BlockPos)pos)) {
            this.blockList.add(inv.field_70458_d.field_70170_p.func_180495_p(p));
        }
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.func_230480_a_(new GuiInnerScreen(this, 7, 11, 63, 49));
        this.func_230480_a_(new GuiInnerScreen(this, 74, 11, 51, 159));
        this.scrollBar = (GuiScrollBar)this.func_230480_a_(new GuiScrollBar((IGuiWrapper)this, 126, 25, 131, this.blockList::size, () -> 1));
        this.func_230480_a_(new GuiArrowSelection(this, 76, 81, () -> {
            int currentLayer = this.scrollBar.getCurrentSelection();
            if (currentLayer >= 0) {
                return this.blockList.get(this.blockList.size() - 1 - currentLayer).func_177230_c().func_235333_g_();
            }
            return null;
        }));
        this.upButton = (MekanismButton)this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, 126, 11, 14, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "up.png"), () -> this.scrollBar.adjustScroll(1.0)));
        this.downButton = (MekanismButton)this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, 126, 156, 14, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "down.png"), () -> this.scrollBar.adjustScroll(-1.0)));
        this.updateEnabledButtons();
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        int currentLayer = this.scrollBar.getCurrentSelection();
        this.upButton.field_230693_o_ = currentLayer > 0;
        this.downButton.field_230693_o_ = currentLayer + 1 < this.blockList.size();
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        int currentLayer = this.blockList.size() - this.scrollBar.getCurrentSelection() - 1;
        this.drawTextScaledBound(matrix, (ITextComponent)TextComponentUtil.build(currentLayer), 111.0f, 87.0f, this.screenTextColor(), 13.0f);
        for (int i = 0; i < 9; ++i) {
            int layer = currentLayer + (i - 4);
            if (0 > layer || layer >= this.blockList.size()) continue;
            BlockState state = this.blockList.get(layer);
            ItemStack stack = new ItemStack((IItemProvider)state.func_177230_c());
            int renderX = 92;
            int renderY = 147 - 16 * i;
            if (i == 4) {
                this.renderItem(matrix, stack, renderX, renderY);
                continue;
            }
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)renderX, (double)renderY, 0.0);
            if (i < 4) {
                matrix.func_227861_a_((double)1.7f, 2.5, 0.0);
            } else {
                matrix.func_227861_a_(1.5, 0.0, 0.0);
            }
            matrix.func_227862_a_(0.8f, 0.8f, 0.8f);
            this.renderItem(matrix, stack, 0, 0);
            matrix.func_227865_b_();
        }
        int frequency = 0;
        if (currentLayer >= 0) {
            Block block = this.blockList.get(currentLayer).func_177230_c();
            IFormattableTextComponent displayName = block.func_235333_g_();
            this.drawTextScaledBound(matrix, (ITextComponent)displayName, 10.0f, 16.0f, this.screenTextColor(), 57.0f);
            frequency = this.frequencies.computeIntIfAbsent((Object)block, b -> (int)this.blockList.stream().filter(blockState -> b == blockState.func_177230_c()).count());
        }
        this.drawTextScaledBound(matrix, (ITextComponent)MekanismLang.ABUNDANCY.translate(frequency), 10.0f, 26.0f, this.screenTextColor(), 57.0f);
        MekanismRenderer.resetColor();
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        return super.func_231043_a_(mouseX, mouseY, delta) || this.scrollBar.adjustScroll(delta);
    }
}

