/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.client.gui.GuiFilterHolder;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiDigitalSwitch;
import mekanism.client.gui.element.button.FilterButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.window.filter.miner.GuiMinerFilerSelect;
import mekanism.client.gui.element.window.filter.miner.GuiMinerItemStackFilter;
import mekanism.client.gui.element.window.filter.miner.GuiMinerMaterialFilter;
import mekanism.client.gui.element.window.filter.miner.GuiMinerModIDFilter;
import mekanism.client.gui.element.window.filter.miner.GuiMinerTagFilter;
import mekanism.client.gui.warning.WarningTracker;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.base.TagCache;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.miner.MinerItemStackFilter;
import mekanism.common.content.miner.MinerMaterialFilter;
import mekanism.common.content.miner.MinerModIDFilter;
import mekanism.common.content.miner.MinerTagFilter;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.to_server.PacketGuiButtonPress;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.InputValidator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;

public class GuiDigitalMinerConfig
extends GuiFilterHolder<MinerFilter<?>, TileEntityDigitalMiner, MekanismTileContainer<TileEntityDigitalMiner>> {
    private static final ResourceLocation INVERSE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "switch/inverse.png");
    private GuiTextField radiusField;
    private GuiTextField minField;
    private GuiTextField maxField;

    public GuiDigitalMinerConfig(MekanismTileContainer<TileEntityDigitalMiner> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.func_230480_a_(new TranslationButton(this, 56, 136, 96, 20, MekanismLang.BUTTON_NEW_FILTER, () -> this.addWindow(new GuiMinerFilerSelect(this, (TileEntityDigitalMiner)this.tile))));
        this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, 5, 5, 11, 14, this.getButtonLocation("back"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON, this.tile))));
        this.func_230480_a_(new GuiDigitalSwitch(this, 10, 115, INVERSE, ((TileEntityDigitalMiner)this.tile)::getInverse, (ITextComponent)MekanismLang.MINER_INVERSE.translate(new Object[0]), () -> Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.INVERSE_BUTTON, this.tile)), GuiDigitalSwitch.SwitchType.LEFT_ICON));
        ((GuiSlot)this.func_230480_a_(new GuiSlot(SlotType.NORMAL, this, 13, 135))).setRenderAboveSlots().setRenderHover(true).stored(() -> new ItemStack((IItemProvider)((TileEntityDigitalMiner)this.tile).getInverseReplaceTarget())).click((element, mouseX, mouseY) -> {
            if (Screen.func_231173_s_()) {
                this.updateInverseReplaceTarget(Items.field_190931_a);
            } else {
                ItemStack stack = this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o();
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof BlockItem) {
                    this.updateInverseReplaceTarget(stack.func_77973_b());
                }
            }
        }).setGhostHandler(ingredient -> this.updateInverseReplaceTarget(((ItemStack)ingredient).func_77973_b()));
        this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, 35, 137, 14, 16, this.getButtonLocation("exclamation"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.INVERSE_REQUIRES_REPLACEMENT_BUTTON, this.tile)), this.getOnHover(() -> MekanismLang.MINER_REQUIRE_REPLACE_INVERSE.translate(BooleanStateDisplay.YesNo.of(((TileEntityDigitalMiner)this.tile).getInverseRequiresReplacement())))));
        this.radiusField = (GuiTextField)this.func_230480_a_(new GuiTextField(this, 13, 49, 38, 11));
        this.radiusField.setMaxStringLength(Integer.toString(MekanismConfig.general.minerMaxRadius.get()).length());
        this.radiusField.setInputValidator(InputValidator.DIGIT);
        this.radiusField.configureDigitalBorderInput(() -> this.setText(this.radiusField, PacketGuiInteract.GuiInteraction.SET_RADIUS));
        this.minField = (GuiTextField)this.func_230480_a_(new GuiTextField(this, 13, 74, 38, 11));
        this.minField.setMaxStringLength(3);
        this.minField.setInputValidator(InputValidator.DIGIT);
        this.minField.configureDigitalBorderInput(() -> this.setText(this.minField, PacketGuiInteract.GuiInteraction.SET_MIN_Y));
        this.maxField = (GuiTextField)this.func_230480_a_(new GuiTextField(this, 13, 99, 38, 11));
        this.maxField.setMaxStringLength(3);
        this.maxField.setInputValidator(InputValidator.DIGIT);
        this.maxField.configureDigitalBorderInput(() -> this.setText(this.maxField, PacketGuiInteract.GuiInteraction.SET_MAX_Y));
        this.trackWarning(WarningTracker.WarningType.FILTER_HAS_BLACKLISTED_ELEMENT, () -> ((TileEntityDigitalMiner)this.tile).getFilters().stream().anyMatch(MinerFilter::hasBlacklistedElement));
    }

    private void updateInverseReplaceTarget(Item target) {
        Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteractionItem.DIGITAL_MINER_INVERSE_REPLACE_ITEM, (TileEntity)this.tile, new ItemStack((IItemProvider)target)));
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    @Override
    protected void addGenericTabs() {
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        super.drawForegroundText(matrix, mouseX, mouseY);
        this.drawTitleText(matrix, (ITextComponent)MekanismLang.MINER_CONFIG.translate(new Object[0]), this.field_238743_q_);
        this.drawScaledTextScaledBound(matrix, (ITextComponent)MekanismLang.FILTERS.translate(new Object[0]), 14.0f, 22.0f, this.screenTextColor(), 36.0f, 0.8f);
        this.drawScaledTextScaledBound(matrix, (ITextComponent)MekanismLang.FILTER_COUNT.translate(this.getFilters().size()), 14.0f, 31.0f, this.screenTextColor(), 36.0f, 0.8f);
        this.drawScaledTextScaledBound(matrix, (ITextComponent)MekanismLang.MINER_RADIUS.translate(((TileEntityDigitalMiner)this.tile).getRadius()), 14.0f, 40.0f, this.screenTextColor(), 36.0f, 0.8f);
        this.drawScaledTextScaledBound(matrix, (ITextComponent)MekanismLang.MIN.translate(((TileEntityDigitalMiner)this.tile).getMinY()), 14.0f, 65.0f, this.screenTextColor(), 36.0f, 0.8f);
        this.drawScaledTextScaledBound(matrix, (ITextComponent)MekanismLang.MAX.translate(((TileEntityDigitalMiner)this.tile).getMaxY()), 14.0f, 90.0f, this.screenTextColor(), 36.0f, 0.8f);
    }

    @Override
    public void drawTitleText(MatrixStack matrix, ITextComponent text, float y) {
        int leftShift = 11;
        int xSize = this.getXSize() - leftShift;
        int maxLength = xSize - 12;
        float textWidth = this.getStringWidth(text);
        float scale = Math.min(1.0f, (float)maxLength / textWidth);
        this.drawScaledCenteredText(matrix, text, (float)leftShift + (float)xSize / 2.0f, y, this.titleTextColor(), scale);
    }

    @Override
    protected void onClick(IFilter<?> filter, int index) {
        if (filter instanceof IItemStackFilter) {
            this.addWindow(GuiMinerItemStackFilter.edit(this, (TileEntityDigitalMiner)this.tile, (MinerItemStackFilter)filter));
        } else if (filter instanceof ITagFilter) {
            this.addWindow(GuiMinerTagFilter.edit(this, (TileEntityDigitalMiner)this.tile, (MinerTagFilter)filter));
        } else if (filter instanceof IMaterialFilter) {
            this.addWindow(GuiMinerMaterialFilter.edit(this, (TileEntityDigitalMiner)this.tile, (MinerMaterialFilter)filter));
        } else if (filter instanceof IModIDFilter) {
            this.addWindow(GuiMinerModIDFilter.edit(this, (TileEntityDigitalMiner)this.tile, (MinerModIDFilter)filter));
        }
    }

    @Override
    protected FilterButton addFilterButton(FilterButton button) {
        return super.addFilterButton(button).warning(WarningTracker.WarningType.FILTER_HAS_BLACKLISTED_ELEMENT, filter -> filter instanceof MinerFilter && ((MinerFilter)filter).hasBlacklistedElement());
    }

    private void setText(GuiTextField field, PacketGuiInteract.GuiInteraction interaction) {
        if (!field.getText().isEmpty()) {
            Mekanism.packetHandler.sendToServer(new PacketGuiInteract(interaction, (TileEntity)this.tile, Integer.parseInt(field.getText())));
            field.setText("");
        }
    }

    @Override
    protected List<ItemStack> getTagStacks(String tagName) {
        return TagCache.getBlockTagStacks(tagName);
    }
}

