/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiEmptyBar;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;

public class ItemStackGasToItemStackRecipeCategory
extends BaseRecipeCategory<ItemStackGasToItemStackRecipe> {
    private final GuiBar<?> gasInput;
    private final GuiSlot input = this.addSlot(SlotType.INPUT, 64, 17);
    private final GuiSlot extra = this.addSlot(SlotType.EXTRA, 64, 53);
    private final GuiSlot output = this.addSlot(SlotType.OUTPUT, 116, 35);

    public ItemStackGasToItemStackRecipeCategory(IGuiHelper helper, IBlockProvider mekanismBlock) {
        super(helper, mekanismBlock, 28, 16, 144, 54);
        this.addSlot(SlotType.POWER, 39, 35).with(SlotOverlay.POWER);
        this.addElement(new GuiVerticalPowerBar((IGuiWrapper)this, FULL_BAR, 164, 15));
        this.gasInput = this.addElement(new GuiEmptyBar(this, 68, 36, 6, 12));
        this.addSimpleProgress(ProgressType.BAR, 86, 38);
    }

    public Class<? extends ItemStackGasToItemStackRecipe> getRecipeClass() {
        return ItemStackGasToItemStackRecipe.class;
    }

    public void setIngredients(ItemStackGasToItemStackRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getItemInput().getRepresentations()));
        List<@NonNull TYPE> gasInputs = ((GasStackIngredient)recipe.getChemicalInput()).getRepresentations();
        List scaledGases = gasInputs.stream().map(gas -> new GasStack((GasStack)gas, gas.getAmount() * 200L)).collect(Collectors.toList());
        ingredients.setInputLists(MekanismJEI.TYPE_GAS, Collections.singletonList(scaledGases));
        ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getOutputDefinition()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, ItemStackGasToItemStackRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        this.initItem((IGuiIngredientGroup<ItemStack>)itemStacks, 0, true, this.input, recipe.getItemInput().getRepresentations());
        this.initItem((IGuiIngredientGroup<ItemStack>)itemStacks, 1, false, this.output, recipe.getOutputDefinition());
        ArrayList<ItemStack> gasItemProviders = new ArrayList<ItemStack>();
        ArrayList<GasStack> scaledGases = new ArrayList<GasStack>();
        for (GasStack gas : ((GasStackIngredient)recipe.getChemicalInput()).getRepresentations()) {
            gasItemProviders.addAll(MekanismJEI.GAS_STACK_HELPER.getStacksFor(gas.getType(), true));
            scaledGases.add(new GasStack(gas, gas.getAmount() * 200L));
        }
        this.initItem((IGuiIngredientGroup<ItemStack>)itemStacks, 2, true, this.extra, gasItemProviders);
        IGuiIngredientGroup gasStacks = recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_GAS);
        this.initChemical(gasStacks, 0, true, this.gasInput, scaledGases);
    }
}

