/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import mekanism.common.Mekanism;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;

public class BaseModelCache {
    private final Map<ResourceLocation, ModelData> modelMap = new Object2ObjectOpenHashMap();

    public void onBake(ModelBakeEvent evt) {
        this.modelMap.values().forEach(m -> m.reload(evt));
    }

    public void setup() {
        this.modelMap.values().forEach(ModelData::setup);
    }

    protected OBJModelData registerOBJ(ResourceLocation rl) {
        return this.register(rl, OBJModelData::new);
    }

    protected JSONModelData registerJSON(ResourceLocation rl) {
        return this.register(rl, x$0 -> new JSONModelData((ResourceLocation)x$0));
    }

    protected <DATA extends ModelData> DATA register(ResourceLocation rl, Function<ResourceLocation, DATA> creator) {
        ModelData data = (ModelData)creator.apply(rl);
        this.modelMap.put(rl, data);
        return (DATA)data;
    }

    public static IBakedModel getBakedModel(ModelBakeEvent evt, ResourceLocation rl) {
        IBakedModel bakedModel = (IBakedModel)evt.getModelRegistry().get(rl);
        if (bakedModel == null) {
            Mekanism.logger.error("Baked model doesn't exist: {}", (Object)rl.toString());
            return evt.getModelManager().func_174951_a();
        }
        return bakedModel;
    }

    public static class JSONModelData
    extends ModelData {
        private IBakedModel bakedModel;

        private JSONModelData(ResourceLocation rl) {
            super(rl);
        }

        @Override
        protected void reload(ModelBakeEvent evt) {
            super.reload(evt);
            this.bakedModel = BaseModelCache.getBakedModel(evt, this.rl);
            IUnbakedModel unbaked = evt.getModelLoader().func_209597_a(this.rl);
            if (unbaked instanceof BlockModel) {
                this.model = ((BlockModel)unbaked).customData.getCustomGeometry();
            }
        }

        @Override
        protected void setup() {
            ModelLoader.addSpecialModel((ResourceLocation)this.rl);
        }

        public IBakedModel getBakedModel() {
            return this.bakedModel;
        }
    }

    public static class OBJModelData
    extends ModelData {
        protected OBJModelData(ResourceLocation rl) {
            super(rl);
        }

        @Override
        protected void reload(ModelBakeEvent evt) {
            super.reload(evt);
            this.model = OBJLoader.INSTANCE.loadModel(new OBJModel.ModelSettings(this.rl, true, true, true, true, null));
        }
    }

    public static class ModelData {
        protected IModelGeometry<?> model;
        protected final ResourceLocation rl;
        private final Map<IModelConfiguration, IBakedModel> bakedMap = new Object2ObjectOpenHashMap();

        protected ModelData(ResourceLocation rl) {
            this.rl = rl;
        }

        protected void reload(ModelBakeEvent evt) {
            this.bakedMap.clear();
        }

        protected void setup() {
        }

        public IBakedModel bake(IModelConfiguration config) {
            return this.bakedMap.computeIfAbsent(config, c -> this.model.bake(c, (ModelBakery)ModelLoader.instance(), ModelLoader.defaultTextureGetter(), (IModelTransform)SimpleModelTransform.IDENTITY, ItemOverrideList.field_188022_a, this.rl));
        }

        public IModelGeometry<?> getModel() {
            return this.model;
        }
    }
}

