/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import mekanism.api.MekanismAPI;
import mekanism.api.gear.IHUDElement;
import mekanism.api.text.ILangEntry;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.HUDElement;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.item.gear.ItemMekaTool;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class HUDRenderer {
    private static final ResourceLocation HEAD_ICON = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekasuit_helmet.png");
    private static final ResourceLocation CHEST_ICON = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekasuit_chest.png");
    private static final ResourceLocation LEGS_ICON = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekasuit_leggings.png");
    private static final ResourceLocation BOOTS_ICON = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekasuit_boots.png");
    private static final ResourceLocation TOOL_ICON = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekatool.png");
    private static final ResourceLocation COMPASS = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "compass.png");
    private long lastTick = -1L;
    private float prevRotationYaw;
    private float prevRotationPitch;
    private final Minecraft minecraft = Minecraft.func_71410_x();

    public void renderHUD(MatrixStack matrix, float partialTick) {
        this.update();
        if (MekanismConfig.client.hudOpacity.get() < 0.05f) {
            return;
        }
        int color = HUDElement.HUDColor.REGULAR.getColorARGB();
        matrix.func_227860_a_();
        float yawJitter = -HUDRenderer.absSqrt(this.minecraft.field_71439_g.field_70759_as - this.prevRotationYaw);
        float pitchJitter = -HUDRenderer.absSqrt(this.minecraft.field_71439_g.field_70125_A - this.prevRotationPitch);
        matrix.func_227861_a_((double)yawJitter, (double)pitchJitter, 0.0);
        if (MekanismConfig.client.hudCompassEnabled.get()) {
            this.renderCompass(matrix, partialTick, color);
        }
        this.renderMekaSuitEnergyIcons(matrix, partialTick, color);
        this.renderMekaSuitModuleIcons(matrix, partialTick, color);
        matrix.func_227865_b_();
    }

    private void update() {
        if (this.lastTick == -1L || this.minecraft.field_71441_e.func_82737_E() - this.lastTick > 1L) {
            this.prevRotationYaw = this.minecraft.field_71439_g.field_70177_z;
            this.prevRotationPitch = this.minecraft.field_71439_g.field_70125_A;
        }
        this.lastTick = this.minecraft.field_71441_e.func_82737_E();
        float yawDiff = this.minecraft.field_71439_g.field_70759_as - this.prevRotationYaw;
        float pitchDiff = this.minecraft.field_71439_g.field_70125_A - this.prevRotationPitch;
        this.prevRotationYaw += yawDiff / MekanismConfig.client.hudJitter.get();
        this.prevRotationPitch += pitchDiff / MekanismConfig.client.hudJitter.get();
    }

    private static float absSqrt(float val) {
        float ret = (float)Math.sqrt(Math.abs(val));
        return val < 0.0f ? -ret : ret;
    }

    private void renderMekaSuitEnergyIcons(MatrixStack matrix, float partialTick, int color) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(10.0, 10.0, 0.0);
        int posX = 0;
        posX += this.renderEnergyIcon(matrix, posX, color, HEAD_ICON, EquipmentSlotType.HEAD);
        posX += this.renderEnergyIcon(matrix, posX, color, CHEST_ICON, EquipmentSlotType.CHEST);
        posX += this.renderEnergyIcon(matrix, posX, color, LEGS_ICON, EquipmentSlotType.LEGS);
        posX += this.renderEnergyIcon(matrix, posX, color, BOOTS_ICON, EquipmentSlotType.FEET);
        posX += this.renderEnergyIcon(matrix, posX, color, TOOL_ICON, EquipmentSlotType.MAINHAND);
        this.renderEnergyIcon(matrix, posX, color, TOOL_ICON, EquipmentSlotType.OFFHAND);
        matrix.func_227865_b_();
    }

    private int renderEnergyIcon(MatrixStack matrix, int posX, int color, ResourceLocation icon, EquipmentSlotType slot) {
        ItemStack stack = this.getStack(slot);
        if (stack.func_77973_b() instanceof ItemMekaSuitArmor || stack.func_77973_b() instanceof ItemMekaTool) {
            this.renderHUDElement(matrix, posX, 0, MekanismAPI.getModuleHelper().hudElementPercent(icon, StorageUtils.getEnergyRatio(stack)), color, false);
            return 48;
        }
        return 0;
    }

    private void renderMekaSuitModuleIcons(MatrixStack matrix, float partialTick, int color) {
        ItemStack stack;
        ArrayList elements = new ArrayList();
        for (EquipmentSlotType type : EnumUtils.ARMOR_SLOTS) {
            stack = this.getStack(type);
            if (!(stack.func_77973_b() instanceof ItemMekaSuitArmor)) continue;
            elements.addAll(((ItemMekaSuitArmor)stack.func_77973_b()).getHUDElements((PlayerEntity)this.minecraft.field_71439_g, stack));
        }
        for (EquipmentSlotType type : EnumUtils.HAND_SLOTS) {
            stack = this.getStack(type);
            if (!(stack.func_77973_b() instanceof ItemMekaTool)) continue;
            elements.addAll(((ItemMekaTool)stack.func_77973_b()).getHUDElements((PlayerEntity)this.minecraft.field_71439_g, stack));
        }
        int startX = this.minecraft.func_228018_at_().func_198107_o() - 10;
        int curY = this.minecraft.func_228018_at_().func_198087_p() - 10;
        matrix.func_227860_a_();
        for (IHUDElement element : elements) {
            int elementWidth = 24 + this.minecraft.field_71466_p.func_238414_a_((ITextProperties)element.getText());
            this.renderHUDElement(matrix, startX - elementWidth, curY -= 18, element, color, true);
        }
        matrix.func_227865_b_();
    }

    private void renderHUDElement(MatrixStack matrix, int x, int y, IHUDElement element, int color, boolean iconRight) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        MekanismRenderer.color(color);
        this.minecraft.func_110434_K().func_110577_a(element.getIcon());
        if (!iconRight) {
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            MekanismRenderer.resetColor();
            this.minecraft.field_71466_p.func_243248_b(matrix, element.getText(), (float)(x + 18), (float)(y + 5), element.getColor());
        } else {
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(x + this.minecraft.field_71466_p.func_238414_a_((ITextProperties)element.getText()) + 2), (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            MekanismRenderer.resetColor();
            this.minecraft.field_71466_p.func_243248_b(matrix, element.getText(), (float)x, (float)(y + 5), element.getColor());
        }
    }

    private void renderCompass(MatrixStack matrix, float partialTick, int color) {
        matrix.func_227860_a_();
        int posX = 25;
        int posY = this.minecraft.func_228018_at_().func_198087_p() - 100;
        matrix.func_227861_a_((double)(posX + 50), (double)(posY + 50), 0.0);
        matrix.func_227860_a_();
        float angle = 180.0f - MathHelper.func_219799_g((float)partialTick, (float)this.minecraft.field_71439_g.field_70758_at, (float)this.minecraft.field_71439_g.field_70759_as);
        matrix.func_227860_a_();
        matrix.func_227862_a_(0.7f, 0.7f, 0.7f);
        TranslationTextComponent coords = MekanismLang.GENERIC_BLOCK_POS.translate((int)this.minecraft.field_71439_g.func_226277_ct_(), (int)this.minecraft.field_71439_g.func_226278_cu_(), (int)this.minecraft.field_71439_g.func_226281_cx_());
        this.minecraft.field_71466_p.func_243248_b(matrix, (ITextComponent)coords, (float)(-this.minecraft.field_71466_p.func_238414_a_((ITextProperties)coords)) / 2.0f, -4.0f, color);
        matrix.func_227865_b_();
        matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-60.0f));
        matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(angle));
        this.minecraft.func_110434_K().func_110577_a(COMPASS);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        MekanismRenderer.color(color);
        AbstractGui.func_238466_a_((MatrixStack)matrix, (int)-50, (int)-50, (int)100, (int)100, (float)0.0f, (float)0.0f, (int)256, (int)256, (int)256, (int)256);
        this.rotateStr(matrix, MekanismLang.NORTH_SHORT, angle, 0.0f, color);
        this.rotateStr(matrix, MekanismLang.EAST_SHORT, angle, 90.0f, color);
        this.rotateStr(matrix, MekanismLang.SOUTH_SHORT, angle, 180.0f, color);
        this.rotateStr(matrix, MekanismLang.WEST_SHORT, angle, 270.0f, color);
        MekanismRenderer.resetColor();
        matrix.func_227865_b_();
        matrix.func_227865_b_();
    }

    private void rotateStr(MatrixStack matrix, ILangEntry langEntry, float rotation, float shift, int color) {
        matrix.func_227860_a_();
        matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(shift));
        matrix.func_227861_a_(0.0, -50.0, 0.0);
        matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-rotation - shift));
        this.minecraft.field_71466_p.func_243248_b(matrix, (ITextComponent)langEntry.translate(new Object[0]), -2.5f, -4.0f, color);
        matrix.func_227865_b_();
    }

    private ItemStack getStack(EquipmentSlotType type) {
        return this.minecraft.field_71439_g.func_184582_a(type);
    }
}

