/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.util.EnumUtils;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.Direction;

@ParametersAreNonnullByDefault
public class RenderDigitalMiner
extends MekanismTileEntityRenderer<TileEntityDigitalMiner> {
    private static MekanismRenderer.Model3D model;
    private static final int[] colors;

    public static void resetCachedVisuals() {
        model = null;
    }

    public RenderDigitalMiner(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    @Override
    protected void render(TileEntityDigitalMiner miner, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        if (miner.clientRendering && miner.getRadius() <= 64) {
            if (model == null) {
                model = new MekanismRenderer.Model3D();
                model.setTexture(MekanismRenderer.whiteIcon);
                RenderDigitalMiner.model.minX = 0.0f;
                RenderDigitalMiner.model.minY = 0.0f;
                RenderDigitalMiner.model.minZ = 0.0f;
                RenderDigitalMiner.model.maxX = 1.0f;
                RenderDigitalMiner.model.maxY = 1.0f;
                RenderDigitalMiner.model.maxZ = 1.0f;
            }
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)(-miner.getRadius()) + 0.01, (double)(miner.getMinY() - miner.func_174877_v().func_177956_o()) + 0.01, (double)(-miner.getRadius()) + 0.01);
            float diameter = (float)miner.getDiameter() - 0.02f;
            matrix.func_227862_a_(diameter, (float)(miner.getMaxY() - miner.getMinY()) - 0.02f, diameter);
            RenderResizableCuboid.FaceDisplay faceDisplay = this.isInsideBounds(miner.func_174877_v().func_177958_n() - miner.getRadius(), miner.getMinY(), miner.func_174877_v().func_177952_p() - miner.getRadius(), miner.func_174877_v().func_177958_n() + miner.getRadius(), miner.getMaxY(), miner.func_174877_v().func_177952_p() + miner.getRadius()) ? RenderResizableCuboid.FaceDisplay.BACK : RenderResizableCuboid.FaceDisplay.BOTH;
            MekanismRenderer.renderObject(model, matrix, renderer.getBuffer(Atlases.func_228785_j_()), colors, 0xF000F0, overlayLight, faceDisplay);
            matrix.func_227865_b_();
        }
    }

    @Override
    protected String getProfilerSection() {
        return "digitalMiner";
    }

    public boolean shouldRenderOffScreen(TileEntityDigitalMiner tile) {
        return true;
    }

    static {
        colors = new int[EnumUtils.DIRECTIONS.length];
        RenderDigitalMiner.colors[Direction.DOWN.ordinal()] = MekanismRenderer.getColorARGB(255, 255, 255, 0.82f);
        RenderDigitalMiner.colors[Direction.UP.ordinal()] = MekanismRenderer.getColorARGB(255, 255, 255, 0.82f);
        RenderDigitalMiner.colors[Direction.NORTH.ordinal()] = MekanismRenderer.getColorARGB(255, 255, 255, 0.8f);
        RenderDigitalMiner.colors[Direction.SOUTH.ordinal()] = MekanismRenderer.getColorARGB(255, 255, 255, 0.8f);
        RenderDigitalMiner.colors[Direction.WEST.ordinal()] = MekanismRenderer.getColorARGB(255, 255, 255, 0.78f);
        RenderDigitalMiner.colors[Direction.EAST.ordinal()] = MekanismRenderer.getColorARGB(255, 255, 255, 0.78f);
    }
}

