/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.functions.FloatSupplier;
import mekanism.api.gear.IModule;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.mekasuit.ModuleGravitationalModulatingUnit;
import mekanism.common.content.gear.mekasuit.ModuleHydraulicPropulsionUnit;
import mekanism.common.content.gear.mekasuit.ModuleJetpackUnit;
import mekanism.common.content.gear.mekasuit.ModuleLocomotiveBoostingUnit;
import mekanism.common.entity.EntityFlame;
import mekanism.common.item.gear.ItemFlamethrower;
import mekanism.common.item.gear.ItemFreeRunners;
import mekanism.common.item.gear.ItemJetpack;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.item.gear.ItemScubaMask;
import mekanism.common.item.gear.ItemScubaTank;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.registries.MekanismGases;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonPlayerTickHandler {
    public static boolean isOnGroundOrSleeping(PlayerEntity player) {
        int z;
        int y;
        if (player.func_70608_bn()) {
            return true;
        }
        int x = MathHelper.func_76128_c((double)player.func_226277_ct_());
        BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)(player.func_226278_cu_() - 0.01)), z = MathHelper.func_76128_c((double)player.func_226281_cx_()));
        BlockState s = player.field_70170_p.func_180495_p(pos);
        VoxelShape shape = s.func_196954_c((IBlockReader)player.field_70170_p, pos);
        if (shape.func_197766_b()) {
            return false;
        }
        AxisAlignedBB playerBox = player.func_174813_aQ();
        return !s.isAir((IBlockReader)player.field_70170_p, pos) && playerBox.func_72317_d(0.0, -0.01, 0.0).func_72326_a(shape.func_197752_a().func_186670_a(pos));
    }

    public static boolean isScubaMaskOn(PlayerEntity player, ItemStack tank) {
        ItemStack mask = player.func_184582_a(EquipmentSlotType.HEAD);
        return !tank.func_190926_b() && !mask.func_190926_b() && tank.func_77973_b() instanceof ItemScubaTank && mask.func_77973_b() instanceof ItemScubaMask && ChemicalUtil.hasGas(tank) && ((ItemScubaTank)tank.func_77973_b()).getFlowing(tank);
    }

    private static boolean isFlamethrowerOn(PlayerEntity player, ItemStack currentItem) {
        return Mekanism.playerState.isFlamethrowerOn(player) && !currentItem.func_190926_b() && currentItem.func_77973_b() instanceof ItemFlamethrower;
    }

    public static float getStepBoost(PlayerEntity player) {
        ItemStack stack = player.func_184582_a(EquipmentSlotType.FEET);
        if (!stack.func_190926_b() && !player.func_225608_bj_()) {
            ItemFreeRunners freeRunners;
            if (stack.func_77973_b() instanceof ItemFreeRunners && (freeRunners = (ItemFreeRunners)stack.func_77973_b()).getMode(stack) == ItemFreeRunners.FreeRunnerMode.NORMAL) {
                return 0.5f;
            }
            IModule<ModuleHydraulicPropulsionUnit> module = MekanismAPI.getModuleHelper().load(stack, MekanismModules.HYDRAULIC_PROPULSION_UNIT);
            if (module != null && module.isEnabled()) {
                return module.getCustomInstance().getStepHeight();
            }
        }
        return 0.0f;
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side.isServer()) {
            this.tickEnd(event.player);
        }
    }

    private void tickEnd(PlayerEntity player) {
        ItemStack chest;
        EntityFlame flame;
        ItemStack currentItem;
        Mekanism.playerState.updateStepAssist(player);
        if (player instanceof ServerPlayerEntity) {
            RadiationManager.INSTANCE.tickServer((ServerPlayerEntity)player);
        }
        if (CommonPlayerTickHandler.isFlamethrowerOn(player, currentItem = player.field_71071_by.func_70448_g()) && (flame = EntityFlame.create(player)) != null) {
            if (flame.func_70089_S()) {
                player.field_70170_p.func_217376_c((Entity)flame);
            }
            if (MekanismUtils.isPlayingMode(player)) {
                ((ItemFlamethrower)currentItem.func_77973_b()).useGas(currentItem, 1L);
            }
        }
        if (CommonPlayerTickHandler.isJetpackOn(player, chest = player.func_184582_a(EquipmentSlotType.CHEST))) {
            ItemJetpack.JetpackMode mode = CommonPlayerTickHandler.getJetpackMode(chest);
            if (CommonPlayerTickHandler.handleJetpackMotion(player, mode, () -> Mekanism.keyMap.has(player.func_110124_au(), 0))) {
                player.field_70143_R = 0.0f;
                if (player instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)player).field_71135_a.field_147365_f = 0;
                }
            }
            if (chest.func_77973_b() instanceof ItemJetpack) {
                ((ItemJetpack)chest.func_77973_b()).useGas(chest, 1L);
            } else {
                ((ItemMekaSuitArmor)chest.func_77973_b()).useGas(chest, (Gas)MekanismGases.HYDROGEN.get(), 1L);
            }
        }
        if (CommonPlayerTickHandler.isScubaMaskOn(player, chest)) {
            ItemScubaTank tank = (ItemScubaTank)chest.func_77973_b();
            int max = player.func_205010_bg();
            tank.useGas(chest, 1L);
            GasStack received = tank.useGas(chest, max - player.func_70086_ai());
            if (!received.isEmpty()) {
                player.func_70050_g(player.func_70086_ai() + (int)received.getAmount());
            }
            if (player.func_70086_ai() == max) {
                for (EffectInstance effect : player.func_70651_bq()) {
                    for (int i = 0; i < 9; ++i) {
                        MekanismUtils.speedUpEffectSafely((LivingEntity)player, effect);
                    }
                }
            }
        }
        Mekanism.playerState.updateFlightInfo(player);
    }

    public static boolean handleJetpackMotion(PlayerEntity player, ItemJetpack.JetpackMode mode, BooleanSupplier ascendingSupplier) {
        Vector3d motion = player.func_213322_ci();
        if (mode == ItemJetpack.JetpackMode.NORMAL) {
            if (player.func_184613_cA()) {
                Vector3d lookAngle = player.func_70040_Z();
                Vector3d normalizedLook = lookAngle.func_72432_b();
                double d1x = normalizedLook.field_72450_a * 0.15;
                double d1y = normalizedLook.field_72448_b * 0.15;
                double d1z = normalizedLook.field_72449_c * 0.15;
                player.func_213317_d(motion.func_72441_c(lookAngle.field_72450_a * d1x + (lookAngle.field_72450_a * 1.5 - motion.field_72450_a) * 0.5, lookAngle.field_72448_b * d1y + (lookAngle.field_72448_b * 1.5 - motion.field_72448_b) * 0.5, lookAngle.field_72449_c * d1z + (lookAngle.field_72449_c * 1.5 - motion.field_72449_c) * 0.5));
                return false;
            }
            player.func_213293_j(motion.func_82615_a(), Math.min(motion.func_82617_b() + 0.15, 0.5), motion.func_82616_c());
        } else if (mode == ItemJetpack.JetpackMode.HOVER) {
            boolean ascending = ascendingSupplier.getAsBoolean();
            boolean descending = player.func_226274_bn_();
            if (!ascending && !descending || ascending && descending) {
                if (motion.func_82617_b() > 0.0) {
                    player.func_213293_j(motion.func_82615_a(), Math.max(motion.func_82617_b() - 0.15, 0.0), motion.func_82616_c());
                } else if (motion.func_82617_b() < 0.0 && !CommonPlayerTickHandler.isOnGroundOrSleeping(player)) {
                    player.func_213293_j(motion.func_82615_a(), Math.min(motion.func_82617_b() + 0.15, 0.0), motion.func_82616_c());
                }
            } else if (ascending) {
                player.func_213293_j(motion.func_82615_a(), Math.min(motion.func_82617_b() + 0.15, 0.2), motion.func_82616_c());
            } else if (!CommonPlayerTickHandler.isOnGroundOrSleeping(player)) {
                player.func_213293_j(motion.func_82615_a(), Math.max(motion.func_82617_b() - 0.15, -0.2), motion.func_82616_c());
            }
        }
        return true;
    }

    private static boolean isJetpackOn(PlayerEntity player, ItemStack chest) {
        if (!chest.func_190926_b() && !player.func_175149_v()) {
            ItemJetpack.JetpackMode mode = CommonPlayerTickHandler.getJetpackMode(chest);
            if (mode == ItemJetpack.JetpackMode.NORMAL) {
                return Mekanism.keyMap.has(player.func_110124_au(), 0);
            }
            if (mode == ItemJetpack.JetpackMode.HOVER) {
                boolean ascending = Mekanism.keyMap.has(player.func_110124_au(), 0);
                boolean descending = player.func_226274_bn_();
                if (!ascending || descending) {
                    return !CommonPlayerTickHandler.isOnGroundOrSleeping(player);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isGravitationalModulationReady(PlayerEntity player) {
        IModule<ModuleGravitationalModulatingUnit> module = MekanismAPI.getModuleHelper().load(player.func_184582_a(EquipmentSlotType.CHEST), MekanismModules.GRAVITATIONAL_MODULATING_UNIT);
        FloatingLong usage = (FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageGravitationalModulation.get();
        return MekanismUtils.isPlayingMode(player) && module != null && module.isEnabled() && module.getContainerEnergy().greaterOrEqual(usage);
    }

    public static boolean isGravitationalModulationOn(PlayerEntity player) {
        return CommonPlayerTickHandler.isGravitationalModulationReady(player) && player.field_71075_bZ.field_75100_b;
    }

    public static ItemJetpack.JetpackMode getJetpackMode(ItemStack stack) {
        IModule<ModuleJetpackUnit> module;
        if (stack.func_77973_b() instanceof ItemJetpack && ChemicalUtil.hasGas(stack)) {
            return ((ItemJetpack)stack.func_77973_b()).getMode(stack);
        }
        if (stack.func_77973_b() instanceof IModuleContainerItem && ChemicalUtil.hasChemical(stack, (Chemical)MekanismGases.HYDROGEN.get()) && (module = MekanismAPI.getModuleHelper().load(stack, MekanismModules.JETPACK_UNIT)) != null && module.isEnabled()) {
            return module.getCustomInstance().getMode();
        }
        return ItemJetpack.JetpackMode.DISABLED;
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        FallEnergyInfo info;
        ItemStack chestStack;
        ItemStack headStack;
        LivingEntity entity = event.getEntityLiving();
        if (event.getAmount() <= 0.0f || !entity.func_70089_S()) {
            return;
        }
        if (event.getSource().func_82725_o() && !(headStack = entity.func_184582_a(EquipmentSlotType.HEAD)).func_190926_b() && headStack.func_77973_b() instanceof ItemScubaMask && !(chestStack = entity.func_184582_a(EquipmentSlotType.CHEST)).func_190926_b() && chestStack.func_77973_b() instanceof ItemScubaTank && ((ItemScubaTank)chestStack.func_77973_b()).getFlowing(chestStack) && ChemicalUtil.hasGas(chestStack)) {
            event.setCanceled(true);
            return;
        }
        if (event.getSource() == DamageSource.field_76379_h && (info = this.getFallAbsorptionEnergyInfo(entity)) != null && this.tryAbsorbAll(event, info.container, info.damageRatio, info.energyCost)) {
            return;
        }
        if (entity instanceof PlayerEntity && ItemMekaSuitArmor.tryAbsorbAll((PlayerEntity)entity, event.getSource(), event.getAmount())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        float ratioAbsorbed;
        FallEnergyInfo info;
        LivingEntity entity = event.getEntityLiving();
        if (event.getAmount() <= 0.0f || !entity.func_70089_S()) {
            return;
        }
        if (event.getSource() == DamageSource.field_76379_h && (info = this.getFallAbsorptionEnergyInfo(entity)) != null && this.handleDamage(event, info.container, info.damageRatio, info.energyCost)) {
            return;
        }
        if (entity instanceof PlayerEntity && (ratioAbsorbed = ItemMekaSuitArmor.getDamageAbsorbed((PlayerEntity)entity, event.getSource(), event.getAmount())) > 0.0f) {
            float damageRemaining = event.getAmount() * Math.max(0.0f, 1.0f - ratioAbsorbed);
            if (damageRemaining <= 0.0f) {
                event.setCanceled(true);
            } else {
                event.setAmount(damageRemaining);
            }
        }
    }

    private boolean tryAbsorbAll(LivingAttackEvent event, @Nullable IEnergyContainer energyContainer, FloatSupplier absorptionRatio, FloatingLongSupplier energyCost) {
        if (energyContainer != null && absorptionRatio.getAsFloat() == 1.0f) {
            FloatingLong energyRequirement = energyCost.get().multiply(event.getAmount());
            if (energyRequirement.isZero()) {
                event.setCanceled(true);
                return true;
            }
            FloatingLong simulatedExtract = energyContainer.extract(energyRequirement, Action.SIMULATE, AutomationType.MANUAL);
            if (simulatedExtract.equals(energyRequirement)) {
                energyContainer.extract(energyRequirement, Action.EXECUTE, AutomationType.MANUAL);
                event.setCanceled(true);
                return true;
            }
        }
        return false;
    }

    private boolean handleDamage(LivingHurtEvent event, @Nullable IEnergyContainer energyContainer, FloatSupplier absorptionRatio, FloatingLongSupplier energyCost) {
        if (energyContainer != null) {
            float absorption = absorptionRatio.getAsFloat();
            float amount = event.getAmount() * absorption;
            FloatingLong energyRequirement = energyCost.get().multiply(amount);
            float ratioAbsorbed = energyRequirement.isZero() ? absorption : absorption * energyContainer.extract(energyRequirement, Action.EXECUTE, AutomationType.MANUAL).divide(amount).floatValue();
            if (ratioAbsorbed > 0.0f) {
                float damageRemaining = event.getAmount() * Math.max(0.0f, 1.0f - ratioAbsorbed);
                if (damageRemaining <= 0.0f) {
                    event.setCanceled(true);
                    return true;
                }
                event.setAmount(damageRemaining);
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            IModule<ModuleHydraulicPropulsionUnit> module = MekanismAPI.getModuleHelper().load(player.func_184582_a(EquipmentSlotType.FEET), MekanismModules.HYDRAULIC_PROPULSION_UNIT);
            if (module != null && module.isEnabled() && Mekanism.keyMap.has(player.func_110124_au(), 1)) {
                float boost = module.getCustomInstance().getBoost();
                FloatingLong usage = ((FloatingLong)MekanismConfig.gear.mekaSuitBaseJumpEnergyUsage.get()).multiply(boost / 0.1f);
                IEnergyContainer energyContainer = module.getEnergyContainer();
                if (module.canUseEnergy((LivingEntity)player, energyContainer, usage, false)) {
                    IModule<ModuleLocomotiveBoostingUnit> boostModule = MekanismAPI.getModuleHelper().load(player.func_184582_a(EquipmentSlotType.LEGS), MekanismModules.LOCOMOTIVE_BOOSTING_UNIT);
                    if (boostModule != null && boostModule.isEnabled() && boostModule.getCustomInstance().canFunction(boostModule, player)) {
                        boost = (float)Math.sqrt(boost);
                    }
                    player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, (double)boost, 0.0));
                    module.useEnergy((LivingEntity)player, energyContainer, usage, true);
                }
            }
        }
    }

    @Nullable
    private FallEnergyInfo getFallAbsorptionEnergyInfo(LivingEntity base) {
        ItemStack feetStack = base.func_184582_a(EquipmentSlotType.FEET);
        if (!feetStack.func_190926_b()) {
            if (feetStack.func_77973_b() instanceof ItemFreeRunners) {
                ItemFreeRunners boots = (ItemFreeRunners)feetStack.func_77973_b();
                if (boots.getMode(feetStack) == ItemFreeRunners.FreeRunnerMode.NORMAL) {
                    return new FallEnergyInfo(StorageUtils.getEnergyContainer(feetStack, 0), MekanismConfig.gear.freeRunnerFallDamageRatio, MekanismConfig.gear.freeRunnerFallEnergyCost);
                }
            } else if (feetStack.func_77973_b() instanceof ItemMekaSuitArmor) {
                return new FallEnergyInfo(StorageUtils.getEnergyContainer(feetStack, 0), MekanismConfig.gear.mekaSuitFallDamageRatio, MekanismConfig.gear.mekaSuitEnergyUsageFall);
            }
        }
        return null;
    }

    private static class FallEnergyInfo {
        @Nullable
        private final IEnergyContainer container;
        private final FloatSupplier damageRatio;
        private final FloatingLongSupplier energyCost;

        public FallEnergyInfo(@Nullable IEnergyContainer container, FloatSupplier damageRatio, FloatingLongSupplier energyCost) {
            this.container = container;
            this.damageRatio = damageRatio;
            this.energyCost = energyCost;
        }
    }
}

