/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.common.Mekanism;
import mekanism.common.content.gear.mekatool.ModuleShearingUnit;
import mekanism.common.lib.FieldReflectionHelper;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootPredicateManager;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ParentedLootEntry;
import net.minecraft.loot.conditions.Alternative;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.Inverted;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.potion.Potion;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;

public class LootTableModifierReloadListener
implements IResourceManagerReloadListener {
    private static final FieldReflectionHelper<LootPool, List<ILootCondition>> LOOT_POOL_CONDITIONS = new FieldReflectionHelper<LootPool, List>(LootPool.class, "field_186454_b", Collections::emptyList);
    private static final FieldReflectionHelper<LootPool, List<LootEntry>> LOOT_POOL_ENTRIES = new FieldReflectionHelper<LootPool, List>(LootPool.class, "field_186453_a", Collections::emptyList);
    private static final FieldReflectionHelper<LootTable, List<LootPool>> LOOT_TABLE_POOLS = new FieldReflectionHelper<LootTable, List>(LootTable.class, "field_186466_c", Collections::emptyList);
    private static final FieldReflectionHelper<LootEntry, ILootCondition[]> LOOT_ENTRY_CONDITIONS = new FieldReflectionHelper<LootEntry, ILootCondition[]>(LootEntry.class, "field_216144_d", () -> new ILootCondition[0]);
    private static final FieldReflectionHelper<ParentedLootEntry, LootEntry[]> PARENTED_LOOT_ENTRY_CHILDREN = new FieldReflectionHelper<ParentedLootEntry, LootEntry[]>(ParentedLootEntry.class, "field_216147_c", () -> new LootEntry[0]);
    private static final FieldReflectionHelper<Alternative, ILootCondition[]> ALTERNATIVE_CONDITION = new FieldReflectionHelper<Alternative, ILootCondition[]>(Alternative.class, "field_215962_a", () -> new ILootCondition[0]);
    private static final FieldReflectionHelper<Inverted, ILootCondition> INVERTED_CONDITION = new FieldReflectionHelper<Inverted, ILootCondition>(Inverted.class, "field_215981_a", () -> null);
    private static final FieldReflectionHelper<ItemPredicate, ITag<Item>> ITEM_PREDICATE_TAG = new FieldReflectionHelper<ItemPredicate, ITag>(ItemPredicate.class, "field_200018_b", () -> null);
    private static final FieldReflectionHelper<ItemPredicate, Item> ITEM_PREDICATE_ITEM = new FieldReflectionHelper<ItemPredicate, Item>(ItemPredicate.class, "field_192496_b", () -> null);
    private static final FieldReflectionHelper<ItemPredicate, MinMaxBounds.IntBound> ITEM_PREDICATE_COUNT = new FieldReflectionHelper<ItemPredicate, MinMaxBounds.IntBound>(ItemPredicate.class, "field_192498_d", () -> MinMaxBounds.IntBound.field_211347_e);
    private static final FieldReflectionHelper<ItemPredicate, MinMaxBounds.IntBound> ITEM_PREDICATE_DURABILITY = new FieldReflectionHelper<ItemPredicate, MinMaxBounds.IntBound>(ItemPredicate.class, "field_193444_e", () -> MinMaxBounds.IntBound.field_211347_e);
    private static final FieldReflectionHelper<ItemPredicate, EnchantmentPredicate[]> ITEM_PREDICATE_ENCHANTMENTS = new FieldReflectionHelper<ItemPredicate, EnchantmentPredicate[]>(ItemPredicate.class, "field_192499_e", () -> EnchantmentPredicate.field_226534_b_);
    private static final FieldReflectionHelper<ItemPredicate, EnchantmentPredicate[]> ITEM_PREDICATE_STORED_ENCHANTMENTS = new FieldReflectionHelper<ItemPredicate, EnchantmentPredicate[]>(ItemPredicate.class, "field_226656_g_", () -> EnchantmentPredicate.field_226534_b_);
    private static final FieldReflectionHelper<ItemPredicate, Potion> ITEM_PREDICATE_POTION = new FieldReflectionHelper<ItemPredicate, Potion>(ItemPredicate.class, "field_192500_f", () -> null);
    private static final FieldReflectionHelper<ItemPredicate, NBTPredicate> ITEM_PREDICATE_NBT = new FieldReflectionHelper<ItemPredicate, NBTPredicate>(ItemPredicate.class, "field_193445_h", () -> NBTPredicate.field_193479_a);
    private static final FieldReflectionHelper<LootPredicateManager, Map<ResourceLocation, ILootCondition>> LOOT_PREDICATE_CONDITIONS = new FieldReflectionHelper<LootPredicateManager, Map>(LootPredicateManager.class, "field_227512_c_", Collections::emptyMap);
    private static final FieldReflectionHelper<LootPredicateManager.AndCombiner, ILootCondition[]> LOOT_PREDICATE_AND_CONDITION = new FieldReflectionHelper<LootPredicateManager.AndCombiner, ILootCondition[]>(LootPredicateManager.AndCombiner.class, "field_237405_a_", () -> new ILootCondition[0]);
    private final DataPackRegistries dataPackRegistries;

    public LootTableModifierReloadListener(DataPackRegistries dataPackRegistries) {
        this.dataPackRegistries = dataPackRegistries;
    }

    public void func_195410_a(@Nonnull IResourceManager resourceManager) {
        ITag shearsTag = this.dataPackRegistries.func_244358_d().func_241836_b().func_199910_a(new ResourceLocation("forge", "shears"));
        LootTableManager lootTableManager = this.dataPackRegistries.func_240965_c_();
        for (ResourceLocation id : lootTableManager.func_215304_a()) {
            LootTable lootTable = lootTableManager.func_186521_a(id);
            boolean modified = false;
            for (LootPool pool : LOOT_TABLE_POOLS.getValue(lootTable)) {
                for (LootEntry entry : LOOT_POOL_ENTRIES.getValue(pool)) {
                    modified |= LootTableModifierReloadListener.modifyEntry(entry, (ITag<Item>)shearsTag);
                }
                for (ILootCondition condition : LOOT_POOL_CONDITIONS.getValue(pool)) {
                    modified |= LootTableModifierReloadListener.modifyCondition(condition, (ITag<Item>)shearsTag);
                }
            }
            if (!modified) continue;
            Mekanism.logger.debug("Modified and wrapped condition(s) in loot table '{}' to support items with the tool type of shears.", (Object)id);
        }
        LootPredicateManager predicateManager = this.dataPackRegistries.func_240964_b_();
        for (Map.Entry<ResourceLocation, ILootCondition> entry : LOOT_PREDICATE_CONDITIONS.getValue(predicateManager).entrySet()) {
            if (!LootTableModifierReloadListener.modifyCondition(entry.getValue(), (ITag<Item>)shearsTag)) continue;
            Mekanism.logger.debug("Modified and wrapped condition for loot predicate '{}' to support items with the tool type of shears.", (Object)entry.getKey());
        }
    }

    private static boolean modifyEntry(LootEntry entry, ITag<Item> shearsTag) {
        boolean modified = false;
        if (entry instanceof ParentedLootEntry) {
            for (LootEntry child : PARENTED_LOOT_ENTRY_CHILDREN.getValue((ParentedLootEntry)entry)) {
                modified |= LootTableModifierReloadListener.modifyEntry(child, shearsTag);
            }
        }
        return modified |= LootTableModifierReloadListener.modifyConditions(LOOT_ENTRY_CONDITIONS.getValue(entry), shearsTag);
    }

    private static boolean modifyCondition(ILootCondition condition, ITag<Item> shearsTag) {
        if (condition instanceof Alternative) {
            return LootTableModifierReloadListener.modifyConditions(ALTERNATIVE_CONDITION.getValue((Alternative)condition), shearsTag);
        }
        if (condition instanceof LootPredicateManager.AndCombiner) {
            return LootTableModifierReloadListener.modifyConditions(LOOT_PREDICATE_AND_CONDITION.getValue((LootPredicateManager.AndCombiner)condition), shearsTag);
        }
        if (condition instanceof Inverted) {
            ILootCondition inner = INVERTED_CONDITION.getValue((Inverted)condition);
            return inner != null && LootTableModifierReloadListener.modifyCondition(inner, shearsTag);
        }
        if (condition instanceof MatchTool) {
            MatchTool matchToolCondition = (MatchTool)condition;
            ItemPredicate predicate = matchToolCondition.field_216014_a;
            if (ITEM_PREDICATE_ITEM.getValue(predicate) == Items.field_151097_aZ || ITEM_PREDICATE_TAG.getValue(predicate) == shearsTag) {
                matchToolCondition.field_216014_a = new ShearsItemPredicate(predicate);
                return true;
            }
        }
        return false;
    }

    private static boolean modifyConditions(ILootCondition[] conditions, ITag<Item> shearsTag) {
        boolean modified = false;
        for (ILootCondition condition : conditions) {
            modified |= LootTableModifierReloadListener.modifyCondition(condition, shearsTag);
        }
        return modified;
    }

    public static void registerCustomPredicate() {
        ItemPredicate.register((ResourceLocation)ShearsItemPredicate.NAME, ShearsItemPredicate::fromJson);
    }

    private static class ShearsItemPredicate
    extends ItemPredicate {
        public static ResourceLocation NAME = Mekanism.rl("custom_shears");
        private final ItemPredicate inner;

        private ShearsItemPredicate(ItemPredicate inner) {
            super(null, null, (MinMaxBounds.IntBound)ITEM_PREDICATE_COUNT.getValue(inner), (MinMaxBounds.IntBound)ITEM_PREDICATE_DURABILITY.getValue(inner), (EnchantmentPredicate[])ITEM_PREDICATE_ENCHANTMENTS.getValue(inner), (EnchantmentPredicate[])ITEM_PREDICATE_STORED_ENCHANTMENTS.getValue(inner), (Potion)ITEM_PREDICATE_POTION.getValue(inner), (NBTPredicate)ITEM_PREDICATE_NBT.getValue(inner));
            this.inner = inner;
        }

        public boolean func_192493_a(@Nonnull ItemStack stack) {
            return this.inner.func_192493_a(stack) || stack.getToolTypes().contains(ModuleShearingUnit.SHEARS_TOOL_TYPE) && super.func_192493_a(stack);
        }

        @Nonnull
        public static ShearsItemPredicate fromJson(JsonObject json) {
            if (!json.has("inner")) {
                throw new JsonParseException("Missing inner item predicate.");
            }
            return new ShearsItemPredicate(ItemPredicate.func_192492_a((JsonElement)json.get("inner")));
        }

        @Nonnull
        public JsonElement func_200319_a() {
            JsonObject json = (JsonObject)super.func_200319_a();
            json.addProperty("type", NAME.toString());
            json.add("inner", this.inner.func_200319_a());
            return json;
        }
    }
}

