/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ColumnPosArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ChunkCommand {
    private static final LongSet chunkWatchers = new LongOpenHashSet();

    private ChunkCommand() {
    }

    static ArgumentBuilder<CommandSource, ?> register() {
        MinecraftForge.EVENT_BUS.register(ChunkCommand.class);
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"chunk").requires(cs -> cs.func_197034_c(2))).then(WatchCommand.register())).then(UnwatchCommand.register())).then(ClearCommand.register())).then(FlushCommand.register());
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        ChunkCommand.handleChunkEvent((ChunkEvent)event, MekanismLang.COMMAND_CHUNK_LOADED);
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        ChunkCommand.handleChunkEvent((ChunkEvent)event, MekanismLang.COMMAND_CHUNK_UNLOADED);
    }

    private static void handleChunkEvent(ChunkEvent event, ILangEntry direction) {
        if (event.getWorld() == null || event.getWorld().func_201670_d()) {
            return;
        }
        ChunkPos pos = event.getChunk().func_76632_l();
        if (chunkWatchers.contains(pos.func_201841_a())) {
            IFormattableTextComponent message = direction.translateColored(EnumColor.GRAY, EnumColor.INDIGO, ChunkCommand.getPosition(pos));
            event.getWorld().func_217369_A().forEach(arg_0 -> ChunkCommand.lambda$handleChunkEvent$1((ITextComponent)message, arg_0));
        }
    }

    private static ITextComponent getPosition(ChunkPos pos) {
        return MekanismLang.GENERIC_WITH_COMMA.translate(pos.field_77276_a, pos.field_77275_b);
    }

    private static /* synthetic */ void lambda$handleChunkEvent$1(ITextComponent message, PlayerEntity player) {
        player.func_145747_a(message, Util.field_240973_b_);
    }

    private static class FlushCommand {
        private FlushCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return Commands.func_197057_a((String)"flush").executes(ctx -> {
                CommandSource source = (CommandSource)ctx.getSource();
                ServerChunkProvider sp = source.func_197023_e().func_72863_F();
                int startCount = sp.func_73152_e();
                sp.func_217207_a(() -> false);
                source.func_197030_a((ITextComponent)MekanismLang.COMMAND_CHUNK_FLUSH.translateColored(EnumColor.GRAY, EnumColor.INDIGO, startCount - sp.func_73152_e()), true);
                return 0;
            });
        }
    }

    private static class ClearCommand {
        private ClearCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return Commands.func_197057_a((String)"clear").executes(ctx -> {
                int count = chunkWatchers.size();
                chunkWatchers.clear();
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)MekanismLang.COMMAND_CHUNK_CLEAR.translateColored(EnumColor.GRAY, EnumColor.INDIGO, count), true);
                return 0;
            });
        }
    }

    private static class UnwatchCommand {
        private UnwatchCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"unwatch").executes(ctx -> {
                CommandSource source = (CommandSource)ctx.getSource();
                return UnwatchCommand.unwatch(source, new ChunkPos(new BlockPos(source.func_197036_d())));
            })).then(Commands.func_197056_a((String)"pos", (ArgumentType)ColumnPosArgument.func_212603_a()).executes(ctx -> {
                ColumnPos column = ColumnPosArgument.func_218101_a((CommandContext)ctx, (String)"pos");
                return UnwatchCommand.unwatch((CommandSource)ctx.getSource(), new ChunkPos(column.field_219439_a, column.field_219440_b));
            }));
        }

        private static int unwatch(CommandSource source, ChunkPos chunkPos) {
            chunkWatchers.remove(ChunkPos.func_77272_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b));
            source.func_197030_a((ITextComponent)MekanismLang.COMMAND_CHUNK_UNWATCH.translateColored(EnumColor.GRAY, EnumColor.INDIGO, ChunkCommand.getPosition(chunkPos)), true);
            return 0;
        }
    }

    private static class WatchCommand {
        private WatchCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"watch").executes(ctx -> {
                CommandSource source = (CommandSource)ctx.getSource();
                return WatchCommand.watch(source, new ChunkPos(new BlockPos(source.func_197036_d())));
            })).then(Commands.func_197056_a((String)"pos", (ArgumentType)ColumnPosArgument.func_212603_a()).executes(ctx -> {
                ColumnPos column = ColumnPosArgument.func_218101_a((CommandContext)ctx, (String)"pos");
                return WatchCommand.watch((CommandSource)ctx.getSource(), new ChunkPos(column.field_219439_a, column.field_219440_b));
            }));
        }

        private static int watch(CommandSource source, ChunkPos chunkPos) {
            chunkWatchers.add(ChunkPos.func_77272_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b));
            source.func_197030_a((ITextComponent)MekanismLang.COMMAND_CHUNK_WATCH.translateColored(EnumColor.GRAY, EnumColor.INDIGO, ChunkCommand.getPosition(chunkPos)), true);
            return 0;
        }
    }
}

