/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command.builders;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.command.builders.StructureBuilder;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;

public class BuildCommand {
    private static final SimpleCommandExceptionType MISS = new SimpleCommandExceptionType((Message)MekanismLang.COMMAND_ERROR_BUILD_MISS.translate(new Object[0]));
    public static final ArgumentBuilder<CommandSource, ?> COMMAND = ((LiteralArgumentBuilder)Commands.func_197057_a((String)"build").requires(cs -> cs.func_197034_c(2) && cs.func_197022_f() instanceof ServerPlayerEntity)).then(Commands.func_197057_a((String)"remove").executes(ctx -> {
        CommandSource source = (CommandSource)ctx.getSource();
        BlockRayTraceResult result = MekanismUtils.rayTrace((PlayerEntity)source.func_197035_h(), 100.0);
        if (result.func_216346_c() == RayTraceResult.Type.MISS) {
            throw MISS.create();
        }
        BuildCommand.destroy((World)source.func_197023_e(), result.func_216350_a());
        source.func_197030_a((ITextComponent)MekanismLang.COMMAND_BUILD_REMOVED.translateColored(EnumColor.GRAY, new Object[0]), true);
        return 0;
    }));

    private BuildCommand() {
    }

    public static void register(String name, ILangEntry localizedName, StructureBuilder builder) {
        COMMAND.then(Commands.func_197057_a((String)name).executes(ctx -> {
            CommandSource source = (CommandSource)ctx.getSource();
            BlockRayTraceResult result = MekanismUtils.rayTrace((PlayerEntity)source.func_197035_h(), 100.0);
            if (result.func_216346_c() == RayTraceResult.Type.MISS) {
                throw MISS.create();
            }
            BlockPos pos = result.func_216350_a().func_177972_a(Direction.UP);
            builder.build((World)source.func_197023_e(), pos);
            source.func_197030_a((ITextComponent)MekanismLang.COMMAND_BUILD_BUILT.translateColored(EnumColor.GRAY, EnumColor.INDIGO, localizedName), true);
            return 0;
        }));
    }

    private static void destroy(World world, BlockPos pos) throws CommandSyntaxException {
        Long2ObjectOpenHashMap chunkMap = new Long2ObjectOpenHashMap();
        if (!BuildCommand.isMekanismBlock((IWorld)world, (Long2ObjectMap<IChunk>)chunkMap, pos)) {
            throw MISS.create();
        }
        HashSet<BlockPos> traversed = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> openSet = new ArrayDeque<BlockPos>();
        openSet.add(pos);
        traversed.add(pos);
        while (!openSet.isEmpty()) {
            BlockPos ptr = (BlockPos)openSet.poll();
            if (!BuildCommand.isMekanismBlock((IWorld)world, (Long2ObjectMap<IChunk>)chunkMap, ptr)) continue;
            world.func_217377_a(ptr, false);
            for (Direction side : EnumUtils.DIRECTIONS) {
                BlockPos offset = ptr.func_177972_a(side);
                if (!traversed.add(offset)) continue;
                openSet.add(offset);
            }
        }
    }

    private static boolean isMekanismBlock(@Nullable IWorld world, @Nonnull Long2ObjectMap<IChunk> chunkMap, @Nonnull BlockPos pos) {
        Optional<BlockState> state = WorldUtils.getBlockState(world, chunkMap, pos);
        return state.isPresent() && state.get().func_177230_c().getRegistryName().func_110624_b().startsWith("mekanism");
    }
}

