/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.gear.EnchantmentBasedModule;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public interface IModuleContainerItem
extends IItemHUDProvider {
    default public List<Module<?>> getModules(ItemStack stack) {
        return ModuleHelper.INSTANCE.loadAll(stack);
    }

    @Nullable
    default public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getModule(ItemStack stack, IModuleDataProvider<MODULE> typeProvider) {
        return MekanismAPI.getModuleHelper().load(stack, typeProvider);
    }

    default public void addModuleDetails(ItemStack stack, List<ITextComponent> tooltip) {
        for (Module<?> module : this.getModules(stack)) {
            ModuleData<?> data = module.getData();
            if (module.getInstalledCount() > 1) {
                TranslationTextComponent amount = MekanismLang.GENERIC_FRACTION.translate(module.getInstalledCount(), data.getMaxStackSize());
                tooltip.add((ITextComponent)MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(EnumColor.GRAY, data, amount));
                continue;
            }
            tooltip.add((ITextComponent)TextComponentUtil.build(EnumColor.GRAY, data));
        }
    }

    default public boolean hasModule(ItemStack stack, IModuleDataProvider<?> type) {
        CompoundNBT modules = ItemDataUtils.getCompound(stack, "modules");
        if (modules.func_150297_b(type.getRegistryName().toString(), 10)) {
            return true;
        }
        String legacyName = type.getModuleData().getLegacyName();
        return legacyName != null && modules.func_150297_b(legacyName, 10);
    }

    default public boolean isModuleEnabled(ItemStack stack, IModuleDataProvider<?> type) {
        IModule<?> module = this.getModule(stack, type);
        return module != null && module.isEnabled();
    }

    default public void removeModule(ItemStack stack, ModuleData<?> type) {
        IModule module = ModuleHelper.INSTANCE.load(stack, (IModuleDataProvider)type);
        if (module != null) {
            if (((Module)module).getInstalledCount() > 1) {
                ((Module)module).setInstalledCount(((Module)module).getInstalledCount() - 1);
                ((Module)module).save(null);
                ((Module)module).onRemoved(false);
            } else {
                CompoundNBT modules = ItemDataUtils.getCompound(stack, "modules");
                modules.func_82580_o(type.getRegistryName().toString());
                String legacyName = type.getLegacyName();
                if (legacyName != null) {
                    modules.func_82580_o(legacyName);
                }
                ((Module)module).onRemoved(true);
            }
        }
    }

    default public void addModule(ItemStack stack, ModuleData<?> type) {
        IModule module = ModuleHelper.INSTANCE.load(stack, (IModuleDataProvider)type);
        if (module == null) {
            if (!ItemDataUtils.hasData(stack, "modules", 10)) {
                ItemDataUtils.setCompound(stack, "modules", new CompoundNBT());
            }
            ItemDataUtils.getCompound(stack, "modules").func_218657_a(type.getRegistryName().toString(), (INBT)new CompoundNBT());
            ((Module)ModuleHelper.INSTANCE.load(stack, (IModuleDataProvider)type)).onAdded(true);
        } else {
            ((Module)module).setInstalledCount(((Module)module).getInstalledCount() + 1);
            ((Module)module).save(null);
            ((Module)module).onAdded(false);
        }
    }

    @Override
    default public void addHUDStrings(List<ITextComponent> list, PlayerEntity player, ItemStack stack, EquipmentSlotType slotType) {
        for (Module<?> module : this.getModules(stack)) {
            if (!module.renderHUD()) continue;
            module.addHUDStrings(player, list);
        }
    }

    default public List<IHUDElement> getHUDElements(PlayerEntity player, ItemStack stack) {
        ArrayList<IHUDElement> ret = new ArrayList<IHUDElement>();
        for (Module<?> module : this.getModules(stack)) {
            if (!module.renderHUD()) continue;
            module.addHUDElements(player, ret);
        }
        return ret;
    }

    public static boolean hasOtherEnchants(ItemStack stack) {
        MatchedEnchants enchants = new MatchedEnchants(stack);
        IModuleContainerItem.forMatchingEnchants(stack, enchants, (e, module) -> ((MatchedEnchants)e).matchedCount++);
        return enchants.enchantments == null || enchants.matchedCount < enchants.enchantments.size();
    }

    default public void filterTooltips(ItemStack stack, List<ITextComponent> tooltips) {
        ArrayList enchantsToRemove = new ArrayList();
        IModuleContainerItem.forMatchingEnchants(stack, new MatchedEnchants(stack), (e, module) -> enchantsToRemove.add(((EnchantmentBasedModule)module.getCustomInstance()).getEnchantment().func_200305_d(module.getInstalledCount())));
        tooltips.removeAll(enchantsToRemove);
    }

    public static void forMatchingEnchants(ItemStack stack, MatchedEnchants enchants, BiConsumer<MatchedEnchants, IModule<? extends EnchantmentBasedModule<?>>> consumer) {
        for (IModule<EnchantmentBasedModule> module : MekanismAPI.getModuleHelper().loadAll(stack, EnchantmentBasedModule.class)) {
            if (!module.isEnabled() || enchants.getEnchantments().getOrDefault(module.getCustomInstance().getEnchantment(), 0).intValue() != module.getInstalledCount()) continue;
            consumer.accept(enchants, module);
        }
    }

    public static class MatchedEnchants {
        private final ItemStack stack;
        private Map<Enchantment, Integer> enchantments;
        private int matchedCount;

        public MatchedEnchants(ItemStack stack) {
            this.stack = stack;
        }

        public Map<Enchantment, Integer> getEnchantments() {
            if (this.enchantments == null) {
                this.enchantments = EnchantmentHelper.func_82781_a((ItemStack)this.stack);
            }
            return this.enchantments;
        }
    }
}

