/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.gear.ItemJetpack;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.registries.MekanismGases;
import mekanism.common.util.StorageUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

@ParametersAreNonnullByDefault
public class ModuleJetpackUnit
implements ICustomModule<ModuleJetpackUnit> {
    private IModuleConfigItem<ItemJetpack.JetpackMode> jetpackMode;

    @Override
    public void init(IModule<ModuleJetpackUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.jetpackMode = configItemCreator.createConfigItem("jetpack_mode", MekanismLang.MODULE_JETPACK_MODE, new ModuleEnumData<ItemJetpack.JetpackMode>(ItemJetpack.JetpackMode.class, ItemJetpack.JetpackMode.NORMAL));
    }

    @Override
    public void addHUDElements(IModule<ModuleJetpackUnit> module, PlayerEntity player, Consumer<IHUDElement> hudElementAdder) {
        if (module.isEnabled()) {
            ItemStack container = module.getContainer();
            GasStack stored = ((ItemMekaSuitArmor)container.func_77973_b()).getContainedGas(container, (Gas)MekanismGases.HYDROGEN.get());
            double ratio = StorageUtils.getRatio(stored.getAmount(), MekanismConfig.gear.mekaSuitJetpackMaxStorage.getAsLong());
            hudElementAdder.accept(MekanismAPI.getModuleHelper().hudElementPercent(this.jetpackMode.get().getHUDIcon(), ratio));
        }
    }

    @Override
    public void changeMode(IModule<ModuleJetpackUnit> module, PlayerEntity player, ItemStack stack, int shift, boolean displayChangeMessage) {
        if (module.isEnabled()) {
            ItemJetpack.JetpackMode newMode = (ItemJetpack.JetpackMode)this.jetpackMode.get().adjust(shift);
            if (this.jetpackMode.get() != newMode) {
                this.jetpackMode.set(newMode);
                if (displayChangeMessage) {
                    module.displayModeChange(player, (ITextComponent)MekanismLang.MODULE_JETPACK_MODE.translate(new Object[0]), newMode);
                }
            }
        }
    }

    public ItemJetpack.JetpackMode getMode() {
        return this.jetpackMode.get();
    }
}

